#pragma once

#include "boiler.h"
#include "grey_warmer.h"
#include "sender.h"

#include <travel/hotels/boiler/proto/config.pb.h>
#include <travel/hotels/proto/data_config/partner.pb.h>

#include <travel/hotels/lib/cpp/offer_cache_invalidation/cache_invalidation_service.h>
#include <travel/hotels/lib/cpp/mon/tools.h>
#include <travel/hotels/lib/cpp/http/http_service.h>
#include <travel/hotels/lib/cpp/util/flag.h>
#include <travel/hotels/lib/cpp/util/restart_detector.h>
#include <travel/hotels/lib/cpp/yt/persistent_config.h>
#include <travel/hotels/lib/cpp/yt/queue_reader.h>
#include <travel/hotels/lib/cpp/yt/queue_writer.h>
#include <travel/hotels/lib/cpp/yt/lock.h>
#include <travel/hotels/lib/cpp/mon/counter.h>
#include <travel/hotels/lib/cpp/mon/page.h>

#include <util/system/event.h>
#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/thread/pool.h>
#include <util/generic/ptr.h>
#include <util/generic/hash.h>
#include <util/generic/hash_set.h>

#include <tuple>
#include <functional>

namespace NTravel {

class TService {
public:
    TService(const NTravelProto::NBoiler::TConfig& pbCfg, const TString& environment);
    ~TService();
    void Run();
    void Stop();

private:
    struct TCounters : public NMonitor::TCounterSource {
        // Общесервисная всячина
        mutable NMonitor::TCounter  IsReady;

        NMonitor::TDerivCounter OfferBusProcessBoilerMicros;
        NMonitor::TDerivCounter OfferBusProcessGreyWarmerMicros;
        NMonitor::TDerivCounter OfferReqBusProcessBoilerMicros;
        NMonitor::TDerivCounter WarmerBusProcessMicros;

        TService& Service_;

        TCounters(TService& service);
        void QueryCounters(NMonitor::TCounterTable* ct) const override;
    };

    // Configuration
    const NTravelProto::NBoiler::TConfig Config_;

    TAutoEvent               Stop_;
    NHttp::TServer           Http_;
    NMonitor::TBasicPage     CountersPage_;
    NMonitor::THttpService   MonWebService_;

    TCounters                Counters_;
    TGreylist                Greylist_;
    TCacheInvalidationService CacheInvalidationService_;
    TYtQueueReader           OfferBus_;
    TYtQueueReader           OfferReqBus_;
    TYtPersistentConfig<EPartnerId, NTravelProto::NConfig::TPartner> YtConfigPartners_;
    TYtQueueWriter           WarmerStateBusWriter_;
    TYtQueueReader           WarmerStateBusReader_;
    TSender                  Sender_;
    NBoiler::TBoiler         Boiler_;
    NGreyWarmer::TGreyWarmer GreyWarmer_;

    TMutex                   Lock_;
    size_t                   ReadyBusCount_;
    TRestartDetector         RestartDetector_;

    void OnPingNanny(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
    void OnSetLogLevel(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
    bool IsReady() const;

    void ConvertSearcherMessage(TYtQueueMessage& busMessage);
    bool ProcessSearcherMessageShort(const TYtQueueMessage& busMessage);
    bool ProcessOfferReqMessage(const TYtQueueMessage& busMessage);
    bool ProcessKeyBeginWarmMessage(const TYtQueueMessage& busMessage);
    bool ProcessKeyOffersFoundMessage(const TYtQueueMessage& busMessage);
};

} // namespace NTravel
