#include <travel/hotels/busbroker/proto/config.pb.h>
#include <travel/hotels/busbroker/service/service.h>

#include <travel/hotels/lib/cpp/protobuf/config.h>
#include <travel/hotels/lib/cpp/util/signals.h>
#include <travel/hotels/lib/cpp/yt/tools.h>

#include <library/cpp/getopt/opt.h>
#include <library/cpp/logger/global/global.h>
#include <library/cpp/sighandler/async_signals_handler.h>
#include <library/cpp/svnversion/svnversion.h>


int main(int argc, const char* argv[]) {
    SetupSignalHandlers();
    InitGlobalLog2Console(TLOG_INFO);

    TString configDir, env, ytTokenPath;
    bool dbg;
    {
        NLastGetopt::TOpts opts;
        opts.AddHelpOption('h');
        opts.AddLongOption('c', "config-dir", "Path to config dir").Required().StoreResult(&configDir);
        opts.AddLongOption('e', "env", "Environment").StoreResult(&env).DefaultValue("dev");
        opts.AddLongOption('t', "yt-token-path", "Path to YT token").StoreResult(&ytTokenPath);
        opts.AddLongOption('d', "debug", "Enable debug log").SetFlag(&dbg).NoArgument();
        NLastGetopt::TOptsParseResult res(&opts, argc, argv);
    }
    TFsPath configPath(configDir);
    auto pbCfg = NTravel::ReadAppConfigWithSubstitutions<NTravelProto::NBusBroker::TConfig>("busbroker", configPath, env, ytTokenPath, "");

    DoInitGlobalLog(CreateLogBackend(pbCfg.GetOther().GetMainLogFile(), dbg ? TLOG_DEBUG : TLOG_INFO, true));

    INFO_LOG << "Starting busbroker revision " << GetProgramSvnRevision() << ", built on " << GetProgramBuildDate() << Endl;

    NTravel::NYtRpc::Init();
    {
        NTravel::NBusBroker::TService service(pbCfg);
        for (int signal : {SIGINT, SIGTERM}) {
            SetAsyncSignalFunction(signal, [&service](int) {
                service.Stop();
            });
        }
        service.Start();
        service.Wait();
    }
    NTravel::NYtRpc::Shutdown();

    INFO_LOG << "Shutdown finished" << Endl;
    return 0;
}
