#pragma once

#include <travel/hotels/busbroker/proto/config.pb.h>

#include <travel/hotels/lib/cpp/grpc/grpc_async_server.h>
#include <travel/hotels/lib/cpp/http/http_service.h>
#include <travel/hotels/lib/cpp/mon/page.h>
#include <travel/hotels/lib/cpp/permalink_mappers/mappers/permalink_to_cluster_mapper.h>
#include <travel/hotels/lib/cpp/permalink_mappers/mappers/permalink_to_original_ids_mapper.h>
#include <travel/hotels/lib/cpp/util/restart_detector.h>
#include <travel/hotels/lib/cpp/yt/persistent_config.h>
#include <travel/hotels/lib/cpp/yt/queue_writer.h>
#include <travel/hotels/lib/cpp/tvm/tvm_service.h>
#include <travel/hotels/proto/data_config/partner.pb.h>
#include <travel/hotels/proto/offer_invalidation/offer_invalidation_service.grpc.pb.h>

namespace NTravel::NBusBroker {
    struct TBadRequestException : yexception {
    };

    class TService {
    public:
        using TGrpcServer = NGrpc::TAsyncServer<NTravelProto::NOfferInvalidation::OfferInvalidationServiceV1::AsyncService>;

        explicit TService(const NTravelProto::NBusBroker::TConfig& config);
        ~TService() = default;

        void Start();
        void Wait();
        void Stop();

    private:
        void OnSetLogLevel(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
        void OnPing(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
        void OnShutdown(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);
        void OnHttpInvalidateOffers(const NHttp::TRequest& httpReq, const NHttp::TOnResponse& responseCb);

        void OnGrpcInvalidateOffers(const NTravelProto::NOfferInvalidation::TOfferInvalidationReq& req,
                                    const NGrpc::TServerReqMetadata& srvMeta,
                                    const TGrpcServer::TResponseCb<NTravelProto::NOfferInvalidation::TOfferInvalidationResp>& responseCb);
        void OnGrpcPing(const NTravelProto::TPingRpcReq& req,
                        const NGrpc::TServerReqMetadata& srvMeta,
                        const TGrpcServer::TResponseCb<NTravelProto::TPingRpcRsp>& responseCb);

        void InvalidateOffers(const NTravelProto::NOfferInvalidation::TOfferInvalidationReq& req);

        void FillEventFields(const NTravelProto::THotelId& hotelId,
                             const NTravelProto::NOfferInvalidation::TOfferInvalidationReq& req,
                             NTravelProto::NOfferInvalidation::TOfferInvalidationEvent* event) const;

        bool IsReady() const;

        struct TCounters: public NMonitor::TCounterSource {
            explicit TCounters(const TService& service);

            mutable NMonitor::TCounter IsReady;

            NMonitor::TDerivCounter NHttpBadRequests;
            NMonitor::TDerivCounter NHttpUnexpectedErrors;

            NMonitor::TDerivCounter NGrpcBadRequests;
            NMonitor::TDerivCounter NGrpcUnexpectedErrors;

            void QueryCounters(NMonitor::TCounterTable* ct) const override;

            const TService& Service;
        };

        const NTravelProto::NBusBroker::TConfig Config;

        TRestartDetector RestartDetector;

        NTravel::NTvm::TTvmService TvmService;

        TYtQueueWriter OfferBusWriter;
        TYtPersistentConfig<EPartnerId, NTravelProto::NConfig::TPartner> YtConfigPartners;
        NPermalinkMappers::TPermalinkToOriginalIdsMapper PermalinkToOriginalIdsMapper;
        NPermalinkMappers::TPermalinkToClusterMapper PermalinkToClusterMapper;

        NMonitor::TBasicPage CountersPage;
        NMonitor::THttpService MonWebService;
        NHttp::TServer Http;
        TAutoEvent StopEvent;
        TGrpcServer GrpcServer;
        TAtomicFlag IsShuttingDown;
        TCounters Counters;
    };
}
