# -*- coding: utf-8 -*-

# !!! DO NOT USE "from __future__ import annotations" here
# This will break deserialization from dict

from dataclasses import dataclass, field
from typing import Dict

MINUTE = 60
HOUR = 60 * MINUTE
DAY = 24 * HOUR
WEEK = 7 * DAY

MULTIPLIERS = {
    'm': MINUTE,
    'h': HOUR,
    'd': DAY,
    'w': WEEK,
}


def time_converter(text: str) -> int:
    text = text.strip()

    if text.isdecimal():
        return int(text)

    modifier = text[-1]
    multiplier = MULTIPLIERS.get(modifier)

    if multiplier is None:
        raise ValueError(f'"{modifier}" is not valid modifier. Expected one of {MULTIPLIERS.keys()}')

    text = text[:-1].strip()
    return multiplier * int(text)


@dataclass
class YqlOptions:
    token: str


@dataclass
class YtOptions:
    proxy: str
    token: str
    root: str
    requests_path: str


@dataclass
class MetricsOptions:
    project: str
    service: str
    cluster: str
    token: str


@dataclass
class NirvanaWorkflowOptions:
    singleProjectId: str
    singlePoolId: str
    priority: int = 90


@dataclass
class TolokaPoolOptions:
    reward_per_assignment: float


@dataclass
class TriggerOptions:
    workflow_options: NirvanaWorkflowOptions = None
    pool_options: TolokaPoolOptions = None


@dataclass
class StageOptions:
    triggers: Dict[str, TriggerOptions]
    delay: int = field(default=0, metadata={'converter': time_converter})
    job_batching_delay_max: int = field(default=0, metadata={'converter': time_converter})


@dataclass
class Options:
    yql: YqlOptions
    yt: YtOptions
    metrics: MetricsOptions
    stages: Dict[str, StageOptions]
