# -*- coding: utf-8 -*-

# !!! DO NOT USE "from __future__ import annotations" here
# This will break deserialization from dict

from dataclasses import dataclass, field
from enum import Enum
from typing import Dict, List, Optional, Type, Union

from travel.hotels.content_manager.data_model.common import HotelInfo
from travel.hotels.content_manager.data_model.types import (
    ActualizableAttribute, AssigneeSkill, ActualizationStartReason, ClusterizationStartReason, SCDescriptionResult,
    uint
)


@dataclass
class TaskInfo:
    assignment_id: str = ''
    create_ts: uint = 0
    pool_id: str = ''
    reward: float = .0
    stage: str = ''
    status: str = ''
    submit_ts: uint = 0
    worker_id: str = ''


@dataclass
class PermalinkTaskInfo(TaskInfo):
    permalink: uint = 0


@dataclass
class MappingTaskInfo(TaskInfo):
    permalink: uint = 0
    operator_id: str = ''
    orig_hotel_id: str = ''
    mapping_key: str = ''


@dataclass
class DescriptionTaskInfo(TaskInfo):
    carrier_code: str = ''
    car_type_code: str = ''
    sc_code: str = ''


@dataclass
class PopularHotelsData:
    permalink: uint = None
    grouping_key: str = ''


@dataclass
class PermalinkOffer:
    operator_id: str = ''
    orig_hotel_id: str = ''
    mapping_key: str = ''
    orig_room_name: str = ''
    _price: str = ''
    _prices_per_night: str = ''
    _count: str = ''
    _params: str = ''
    _partner_url: str = ''
    _requests_range: str = ''


@dataclass
class OfferInfo:
    offer_room_name: str = ''
    partner_offer_url: str = ''
    offer_comment: str = ''


@dataclass
class AvailablePermaroom:
    permaroom_id: Optional[str] = None
    permaroom_name: str = ''
    alternative_names: str = ''
    permaroom_comment: str = ''


@dataclass
class YangRoomsInputData:
    permalink: str = ''
    altay_url: str = ''
    hotel_url: str = ''
    partner_urls: List[Dict[str, str]] = field(default_factory=list)  # always has one pair
    permalink_offers: List[PermalinkOffer] = field(default_factory=list)
    offer_info: List[OfferInfo] = field(default_factory=list)
    available_permarooms: List[AvailablePermaroom] = field(default_factory=list)


@dataclass
class YangRoomsOutputData:
    result_permarooms: List[AvailablePermaroom] = field(default_factory=list)


@dataclass
class YangRoomsData:
    input: YangRoomsInputData
    output: YangRoomsOutputData
    info: PermalinkTaskInfo


@dataclass
class YangMappingsInputData:
    permalink: str = ''
    permarooms: List[AvailablePermaroom] = field(default_factory=list)
    operator_id: str = ''
    orig_hotel_id: str = ''
    mapping_key: str = ''
    offer_room_name: str = ''
    count: str = ''
    prices_per_night: str = ''
    requests_range: str = ''
    price: str = ''
    partner_offer_url: str = ''
    altay_url: str = ''
    offer_params: str = ''


@dataclass
class YangMappingsOutputData:
    result: str = ''
    offer_comment: str = ''


@dataclass
class YangMappingsData:
    input: YangMappingsInputData
    output: YangMappingsOutputData
    info: MappingTaskInfo


@dataclass
class ActualizationDataInput:
    permalink: str = ''
    altay_url: str = ''
    required_attributes: List[str] = field(default_factory=list)
    requirements: List[str] = field(default_factory=list)
    prev_comments: List[str] = field(default_factory=list)
    hotel_name: str = ''
    assignee_skill: AssigneeSkill = AssigneeSkill.BASIC


class ActualizationDataOutputResult(Enum):
    STAGE_ACTUALIZATION_REQUIRED = 'stage_actualization_required'
    STAGE_CALL_CENTER_REQUIRED = 'stage_call_center_required'
    STAGE_CLUSTERIZATION_REQUIRED = 'stage_clusterization_required'
    SUCCESS = 'success'
    FAILED = 'failed'
    UNKNOWN = 'unknown'


@dataclass
class ActualizationDataOutput:
    result: ActualizationDataOutputResult = ActualizationDataOutputResult.UNKNOWN
    checked_attributes: List[ActualizableAttribute] = field(default_factory=list)
    changed_attributes: List[ActualizableAttribute] = field(default_factory=list)
    assignee_skill: AssigneeSkill = AssigneeSkill.BASIC
    date_next_check: str = ''
    comments: str = ''
    # FAILED
    failed_closed: bool = False
    failed_temporary_closed: bool = False
    failed_unpublished: bool = False
    failed_denied_publishing: bool = False
    failed_technical_fault: bool = False
    failed_no_hotel_rubric: bool = False
    failed_check: bool = False
    failed_other: bool = False


@dataclass
class ActualizationData:
    input: ActualizationDataInput
    output: ActualizationDataOutput
    info: PermalinkTaskInfo


class CallCenterDataOutputResult(Enum):
    SUCCESS_WITH_CALL = 'success with call'
    SUCCESS_WITHOUT_CALL = 'success without call'
    FAILED = 'failed'
    UNKNOWN = 'unknown'
    IN_PROCESS = 'in_process'


@dataclass
class CallCenterDataInput:
    request_id: int
    permalink: int = 0
    required_attributes: List[str] = field(default_factory=list)
    comments: str = ''


@dataclass
class CallCenterDataOutput:
    result: CallCenterDataOutputResult = CallCenterDataOutputResult.UNKNOWN
    request_id: int = None


@dataclass
class CallCenterData:
    input: CallCenterDataInput
    output: CallCenterDataOutput


@dataclass
class ClusterizationDataInput:
    permalink: str = ''
    altay_url: str = ''
    requirements: List[str] = field(default_factory=list)
    prev_comments: List[str] = field(default_factory=list)
    hotel_name: str = ''
    assignee_skill: AssigneeSkill = AssigneeSkill.BASIC
    stage_actualization_required: bool = False
    stage_call_center_required: bool = False


class ClusterizationDataOutputResult(Enum):
    IN_PROCESS = 'in_process'
    SUCCESS = 'success'
    FAILED = 'failed'
    UNKNOWN = 'unknown'


@dataclass
class ClusterizationDataOutput:
    result: ClusterizationDataOutputResult = ClusterizationDataOutputResult.UNKNOWN
    permalink: str = ''
    new_permalinks: Optional[List[str]] = None
    assignee_skill: AssigneeSkill = AssigneeSkill.BASIC
    stage_actualization_required: bool = False
    stage_call_center_required: bool = False
    date_next_check: str = ''
    changes_not_applied: bool = False
    comments: str = ''
    # FAILED
    failed_no_hotel_rubric: bool = False
    failed_unpublished: bool = False
    failed_denied_publishing: bool = False
    failed_technical_fault: bool = False
    failed_closed: bool = False
    failed_temporary_closed: bool = False
    failed_other: bool = False


@dataclass
class ClusterizationData:
    input: ClusterizationDataInput
    output: ClusterizationDataOutput
    info: PermalinkTaskInfo


class RequiredStage(Enum):
    ACTUALIZATION = 'actualization'
    CALL_CENTER = 'call_center'
    CLUSTERIZATION = 'clusterization'


ALLOWED_ATTRIBUTES = ','.join(sorted(a.value for a in set(ActualizableAttribute)))


@dataclass
class WLStartData:
    permalink: uint
    grouping_key: str = field(metadata={'replace': True})
    priority: uint = field(metadata={'merger': max})
    required_stages: str = field(metadata={'item_type': RequiredStage})
    actualization_start_reason: ActualizationStartReason = field(metadata={'replace': True})
    clusterization_start_reason: ClusterizationStartReason = field(metadata={'replace': True})
    assignee_skill: Optional[AssigneeSkill] = field(
        default=None, metadata={'replace': True, 'value': AssigneeSkill.BASIC}
    )
    requirements: Optional[str] = field(
        default=None, metadata={'merger': lambda a, b: '\n'.join(line for line in (a, b) if line), 'value': ''}
    )
    required_attributes: Optional[str] = field(
        default=None, metadata={'item_type': ActualizableAttribute, 'value': ALLOWED_ATTRIBUTES}
    )
    actualization_iteration: Optional[uint] = field(default=None, metadata={'replace': True, 'value': 1})
    actualization_required_stages: Optional[str] = field(
        default=None, metadata={'item_type': RequiredStage, 'value': ''}
    )
    call_center_required_stages: Optional[str] = field(default=None, metadata={'item_type': RequiredStage, 'value': ''})
    clusterization_required_stages: Optional[str] = field(
        default=None, metadata={'item_type': RequiredStage, 'value': ''}
    )
    clusterization_iteration: Optional[uint] = field(default=None, metadata={'replace': True, 'value': 1})
    hotel_name: Optional[str] = field(default=None, metadata={'replace': True, 'value': 'unknown'})


@dataclass
class WLNewHotelsPermalinkData:
    permalink: uint = 0
    grouping_key: str = ''


@dataclass
class WLNewHotelsHotelData:
    permalink: uint = 0
    partner_id: str = ''
    original_id: str = ''
    grouping_key: str = ''


@dataclass
class WLGetHotelInfoHotelData(HotelInfo):
    permalink: uint = 0
    partner_id: str = ''
    original_id: str = ''
    grouping_key: str = ''


@dataclass
class WLGetHotelInfoPermalinkData(HotelInfo):
    permalink: uint = 0
    grouping_key: str = ''


@dataclass
class WLMatchHotelsDataInput:
    permalink: str = ''
    partner_id: str = ''
    original_id: str = ''
    address_1: str = ''
    address_2: str = ''
    category_1: str = ''
    category_2: str = ''
    company_name_1: str = ''
    company_name_2: str = ''
    country_1: str = ''
    country_2: str = ''
    distance: float = .0
    latitude_1: str = ''
    latitude_2: str = ''
    longitude_1: str = ''
    longitude_2: str = ''
    phone_1: str = ''
    phone_2: str = ''
    photo_1: List[str] = field(default_factory=list)
    photo_2: List[str] = field(default_factory=list)
    url_1: str = ''
    url_2: str = ''


@dataclass
class WLMatchHotelsDataOutput:
    result: str = ''


@dataclass
class WLMatchHotelsData:
    input: WLMatchHotelsDataInput
    output: WLMatchHotelsDataOutput


@dataclass
class SCNewDescriptionData:
    carrier_code: str = ''
    car_type_code: str = ''
    sc_code: str = ''


@dataclass
class SCUpdateDescriptionsDataInput:
    carrier_code: str = ''
    car_type_code: str = ''
    sc_code: str = ''
    country: str = ''
    url: str = ''
    carrier_name: str = ''
    car_type_name: str = ''
    sc_name: str = ''
    sc_description: str = ''


@dataclass
class SCUpdateDescriptionsDataOutput:
    is_source_official: bool = False
    data_source: str = ''
    sc_description: str = ''
    sc_description_original: str = ''
    sc_description_specific: List[Dict[str, str]] = field(default_factory=list)
    result: SCDescriptionResult = SCDescriptionResult.UNKNOWN


@dataclass
class SCUpdateDescriptionsData:
    input: SCUpdateDescriptionsDataInput
    output: SCUpdateDescriptionsDataOutput
    info: DescriptionTaskInfo


EntityInfoClass = Union[Type[MappingTaskInfo], Type[PermalinkTaskInfo], Type[DescriptionTaskInfo]]


EntityInfo = Union[MappingTaskInfo, PermalinkTaskInfo, DescriptionTaskInfo]
