# -*- coding: utf-8 -*-
from __future__ import annotations

from enum import Enum
from typing import NewType


uint = NewType('uint', int)


DEFAULT_ENTITY_PRIORITY = uint(50)

EXCEPTIONAL_ENTITY_PRIORITY = uint(2 ** 63 - 1)


class StageResult(Enum):
    UNKNOWN = 'unknown'
    SUCCESS = 'success'
    FAILED = 'failed'


class WLResult(Enum):
    UNKNOWN = 'unknown'
    SUCCESS = 'success'
    FAILED = 'failed'


class ActualizationStartReason(Enum):
    MAIN_ATTRIBUTE_ACTUALIZATION = 'main_attribute_actualization'
    RUBRIC = 'rubric'
    PUBLISHING_STATUS = 'publishing_status'
    UPDATE_ATTRIBUTE = 'update_attribute'
    SHORT_ATTRIBUTE_ACTUALIZATION = 'short_attribute_actualization'
    FULL_ACTUALIZATION = 'full_actualization'


class ClusterizationStartReason(Enum):
    COMMON = 'common'
    BOY_HOTELS = 'boy_hotels'
    UPDATE = 'update'
    COMMON_LIGHT = 'common_light'
    COMMON_INTENSIVE = 'common_intensive'


# !!!DEPRECATED used for migrations only
class ClusterizationStartReasonUpTo20(Enum):
    COMMON = 'common'
    NO_HOTEL_RUBRIC = 'no_hotel_rubric'
    HOTEL_APARTMENT = 'hotel_apartment'
    UNPUBLISHED = 'unpublished'
    BOY_HOTELS = 'boy_hotels'
    SEASON_HOTELS = 'season_hotels'
    UPDATE = 'update'
    CORRECTION = 'correction'
    COMMON_20_6_2 = 'common_20_6_2'


class AssigneeSkill(Enum):
    BASIC = 'basic'
    ADVANCED = 'advanced'
    EDIT = 'edit'


# !!!DEPRECATED used for migrations only
class ClusterizationProgress(Enum):
    NOT_STARTED = 'not_started'
    ON_FIRST_CHECK = 'on_first_check'
    ON_EDIT = 'on_edit'
    ON_RECHECK = 'on_recheck'
    FINISHED = 'finished'


class ProcessType(Enum):
    CATROOM = 'catroom'
    WHITELIST = 'whitelist'
    SERVICE_CLASS = 'service_class'


class SCDescriptionResult(Enum):
    UNKNOWN = 'unknown'
    ACTUAL = 'actual'
    UPDATED = 'updated'
    NO_DATA = 'no_data'


class ActualizableAttribute(Enum):
    PUBLISHING_STATUS = 'publishing_status'
    RUBRICS = 'rubrics'
    CONTACTS = 'contacts'
    NAME = 'name'
    LOCATION = 'location'
    FEATURES = 'features'
