# -*- coding: utf-8 -*-


LOG_CONFIG = {
    'version': 1,
    'disable_existing_loggers': False,
    'handlers': {
        'stdout': {
            'class': 'logging.StreamHandler',
            'formatter': 'default',
            'stream': 'ext://sys.stdout',
        },
    },
    'formatters': {
        'default': {
            'format': '%(asctime)s %(levelname)-8s %(name)-50s %(message)s',
            'datefmt': '%Y-%m-%d %H:%M:%S',
        },
    },
    'loggers': {
        '': {
            'handlers': ['stdout'],
            'level': 'DEBUG',
        },
        'http': {
            'level': 'WARNING',
        },
        'parse': {
            'level': 'WARNING',
        },
        'urllib3.connectionpool': {
            'level': 'WARNING',
        },
        'yql.client.request': {
            'level': 'WARNING',
        },
        'yt.packages.urllib3.connectionpool': {
            'level': 'WARNING',
        },
    },
}
