# -*- coding: utf-8 -*-

from typing import Set

from travel.hotels.content_manager.data_model.storage import DispatchableEntity
from travel.hotels.content_manager.data_model.types import ActualizableAttribute
from travel.hotels.content_manager.lib.common import str_from_set, str_to_set


class Attributes:

    allowed_attributes: str = str_from_set(set(ActualizableAttribute), lambda x: x.value)

    @staticmethod
    def get_attributes_to_check(entity: DispatchableEntity) -> Set[ActualizableAttribute]:
        required_attributes = str_to_set(entity.required_attributes, lambda x: ActualizableAttribute(x))
        checked_attributes = str_to_set(entity.checked_attributes, lambda x: ActualizableAttribute(x))
        return required_attributes - checked_attributes
