# -*- coding: utf-8 -*-
from __future__ import annotations

from typing import Any, Callable, List, NamedTuple


class Task(NamedTuple):
    executor: Callable
    args: tuple


class DelayedExecutor(object):

    def __init__(self) -> None:
        self.tasks: List[Task] = list()

    def schedule(self, executor: Callable, *args: Any) -> None:
        self.tasks.append(Task(executor, args))

    def execute(self) -> None:
        for task in self.tasks:
            task.executor(*task.args)
        self.tasks = list()
