# -*- coding: utf-8 -*-
from __future__ import annotations

from dataclasses import dataclass
from typing import List, Type

from library.python import resource
import yaml

from travel.hotels.content_manager.lib.common import dc_from_dict


def get_available_environments(options_root: str) -> List[str]:
    environments = list()

    if not options_root.endswith('/'):
        options_root += '/'

    root_length = len(options_root)

    for index in range(resource.count()):
        key = resource.key_by_index(index).decode()
        if key.startswith(options_root):
            environments.append(key[root_length:])

    return environments


def get_options(options: str, dc: Type[dataclass]) -> dataclass:
    options_dict = yaml.load(options, yaml.SafeLoader)
    return dc_from_dict(dc, options_dict)


def get_environment_options_file(fn: str, dc: Type[dataclass]) -> dataclass:
    with open(fn) as f:
        options_str = f.read()
    return get_options(options_str, dc)


def get_environment_options_resource(environment: str, options_root: str, dc: Type[dataclass]) -> dataclass:
    if not options_root.endswith('/'):
        options_root += '/'
    resource_key = options_root + environment
    options_str = resource.find(resource_key)
    return get_options(options_str, dc)
