# -*- coding: utf-8 -*-
from __future__ import annotations

from dataclasses import dataclass
from typing import Optional

from travel.hotels.content_manager.lib.persistence_manager import PersistenceManager


@dataclass
class PathInfo:
    root: str
    storage_patches_path: str
    storage_snapshots_path: str
    storage_path: str
    storage_hotels_wl_table: str
    storage_permalinks_table: str
    storage_permalinks_wl_table: str
    storage_permarooms_table: str
    storage_mappings_table: str
    storage_urls_table: str
    storage_sc_descriptions_table: str
    storage_version_table: str
    processor_data_path: str
    logs_path: str
    stages_path: str
    requests_path: str
    history_path: str
    temp_path: str

    def __init__(
            self,
            persistence_manager: PersistenceManager,
            root: str,
            requests_path: Optional[str] = None,
            storage_path: Optional[str] = None,
    ):
        self.root = root

        if requests_path is None:
            requests_path = persistence_manager.join(root, 'requests')

        self.storage_path = persistence_manager.join(root, 'storage')
        if storage_path is not None:
            self.storage_path = storage_path

        self.storage_patches_path = persistence_manager.join(root, 'storage_patches')
        self.storage_snapshots_path = persistence_manager.join(root, 'storage_snapshots')
        self.storage_hotels_wl_table = persistence_manager.join(self.storage_path, 'hotels_wl')
        self.storage_permalinks_table = persistence_manager.join(self.storage_path, 'permalinks')
        self.storage_permalinks_wl_table = persistence_manager.join(self.storage_path, 'permalinks_wl')
        self.storage_permarooms_table = persistence_manager.join(self.storage_path, 'permarooms')
        self.storage_mappings_table = persistence_manager.join(self.storage_path, 'mappings')
        self.storage_urls_table = persistence_manager.join(self.storage_path, 'urls')
        self.storage_sc_descriptions_table = persistence_manager.join(self.storage_path, 'sc_descriptions')
        self.storage_version_table = persistence_manager.join(self.storage_path, 'version')
        self.processor_data_path = persistence_manager.join(root, 'processor_data')
        self.logs_path = persistence_manager.join(root, 'logs')
        self.stages_path = persistence_manager.join(root, 'stages')
        self.requests_path = requests_path
        self.history_path = persistence_manager.join(root, 'history')
        self.temp_path = persistence_manager.join(root, 'temp')
