# -*- coding: utf-8 -*-

from typing import Dict

from travel.hotels.content_manager.data_model import storage
from travel.hotels.content_manager.lib.path_info import PathInfo


class PathMapping:

    def __init__(self, path_info: PathInfo):
        self.entity_to_path: Dict[storage.EntityClass, str] = {
            storage.StorageHotelWL: path_info.storage_hotels_wl_table,
            storage.StoragePermalinkWL: path_info.storage_permalinks_wl_table,
            storage.StoragePermalink: path_info.storage_permalinks_table,
            storage.StoragePermaroom: path_info.storage_permarooms_table,
            storage.StorageMapping: path_info.storage_mappings_table,
            storage.StorageUrl: path_info.storage_urls_table,
            storage.StorageSCDescription: path_info.storage_sc_descriptions_table,
        }
