# -*- coding: utf-8 -*-
from __future__ import annotations

from textwrap import dedent
from typing import Any, Dict, List, Optional

from yql.api.v1.client import YqlClient


class YqlSimpleClient(object):

    def __init__(self, token: str, yt_proxy: str):
        self.client = YqlClient(token=token, db=yt_proxy)
        self.transaction_id: Optional[str] = None

    def run_query(
            self,
            query: str,
            fetch_results: bool = False,
            syntax_version: int = 1,
    ) -> Optional[List[List[Dict[str, Any]]]]:

        query = dedent(query)
        request = self.client.query(query=query, syntax_version=syntax_version)
        request.run(transaction_id=self.transaction_id)
        results = request.get_results()
        if not request.is_success:
            raise RuntimeError(f'Yql query failed: {request.share_url}')
        print()

        if not fetch_results:
            return

        tables = list()

        for table in results:
            table.fetch_full_data()
            table_data = [dict(zip(table.column_names, row)) for row in table.rows]
            tables.append(table_data)

        return tables
