# -*- coding: utf-8 -*-
from __future__ import annotations

from dataclasses import dataclass


@dataclass
class StoragePermalink:
    id: int = 0
    is_synced: bool = False
    is_deleted: bool = False
    tag: str = ''
    hotel_url: str = ''
    marked_by: str = ''
    show_other: bool = False


@dataclass
class StoragePermaroom:
    name: str = ''
    is_synced: bool = False
    is_deleted: bool = False
    is_hidden: bool = False
    permalink: int = 0
    comment: str = ''
    alternative_names: str = ''


@dataclass
class StorageMapping:
    is_synced: bool = False
    is_deleted: bool = False
    permalink: int = 0
    operator_id: str = ''
    orig_hotel_id: str = ''
    mapping_key: str = ''
    permaroom_name: str = ''
    orig_room_name: str = ''
    count: int = 0
    prices_per_night: str = ''
    requests_range: str = ''
    price: int = 0
    url: str = ''
    params: str = ''


@dataclass
class StorageUrl:
    permalink: int
    provider: str = ''
    url: str = ''
