# -*- coding: utf-8 -*-
from __future__ import annotations

from dataclasses import dataclass, field
from enum import Enum

from travel.hotels.content_manager.data_model.types import uint


class StageStatus(Enum):
    NOTHING_TO_DO = 'nothing_to_do'
    TO_BE_PROCESSED = 'to_be_processed'
    IN_PROCESS = 'in_process'


@dataclass
class StoragePermalink:
    id: uint = field(default=0, metadata={'is_key': True})
    is_synced: bool = False
    is_deleted: bool = False
    tag: str = ''
    hotel_url: str = ''
    marked_by: str = ''
    show_other: bool = True
    status_partner_offers: StageStatus = StageStatus.NOTHING_TO_DO
    status_new_offers: StageStatus = StageStatus.NOTHING_TO_DO
    status_yang_rooms: StageStatus = StageStatus.NOTHING_TO_DO


@dataclass
class StoragePermaroom:
    name: str = field(default='', metadata={'is_key': True})
    is_synced: bool = False
    is_deleted: bool = False
    is_hidden: bool = False
    permalink: uint = field(default=0, metadata={'is_key': True, 'foreign_key': StoragePermalink.id})
    comment: str = ''
    alternative_names: str = ''
    status_catroom_sync: StageStatus = StageStatus.NOTHING_TO_DO


@dataclass
class StorageMapping:
    is_synced: bool = False
    is_deleted: bool = False
    need_new_permaroom: bool = False
    permalink: uint = field(default=0, metadata={'is_key': True, 'foreign_key': StoragePermalink.id})
    operator_id: str = field(default='', metadata={'is_key': True})
    orig_hotel_id: str = field(default='', metadata={'is_key': True})
    mapping_key: str = field(default='', metadata={'is_key': True})
    permaroom_name: str = field(default='', metadata={'foreign_key': StoragePermaroom.name})
    orig_room_name: str = ''
    count: int = 0
    prices_per_night: str = ''
    requests_range: str = ''
    price: int = 0
    url: str = ''
    params: str = ''
    comment: str = ''
    status_yang_mappings: StageStatus = StageStatus.NOTHING_TO_DO
    status_catroom_sync: StageStatus = StageStatus.NOTHING_TO_DO


@dataclass
class StorageUrl:
    permalink: uint = field(default=0, metadata={'is_key': True, 'foreign_key': StoragePermalink.id})
    provider: str = field(default='', metadata={'is_key': True})
    url: str = ''
