# -*- coding: utf-8 -*-

# !!! DO NOT USE "from __future__ import annotations" here
# This will break deserialization from dict

from dataclasses import dataclass, field
from enum import Enum
from typing import Dict, Type, Union

from travel.hotels.content_manager.data_model.types import uint


PERMAROOM_ID_OFFSET = 1_000_000


class StageStatus(Enum):
    NOTHING_TO_DO = 'nothing_to_do'
    TO_BE_PROCESSED = 'to_be_processed'
    IN_PROCESS = 'in_process'


@dataclass
class StoragePermalink:
    id: uint = field(default=0, metadata={'is_key': True})
    is_deleted: bool = False
    hotel_url: str = ''
    marked_by: str = ''
    show_other: bool = True
    status_partner_offers: StageStatus = StageStatus.NOTHING_TO_DO
    status_yang_rooms: StageStatus = StageStatus.NOTHING_TO_DO
    status_update_mappings: StageStatus = StageStatus.NOTHING_TO_DO


@dataclass
class StoragePermaroom:
    id: int = field(default=None, metadata={'is_key': True})
    name: str = ''
    is_deleted: bool = False
    permalink: uint = field(default=0, metadata={'is_key': True, 'foreign_key': StoragePermalink.id})
    comment: str = ''
    alternative_names: str = ''


@dataclass
class StorageMapping:
    is_deleted: bool = False
    is_hidden: bool = False
    is_banned: bool = False
    need_new_permaroom: bool = False
    permalink: uint = field(default=0, metadata={'is_key': True, 'foreign_key': StoragePermalink.id})
    operator_id: str = field(default='', metadata={'is_key': True})
    orig_hotel_id: str = field(default='', metadata={'is_key': True})
    mapping_key: str = field(default='', metadata={'is_key': True})
    permaroom_id: int = field(default=None, metadata={'foreign_key': StoragePermaroom.id})
    orig_room_name: str = ''
    count: int = 0
    prices_per_night: str = ''
    requests_range: str = ''
    price: int = 0
    url: str = ''
    params: str = ''
    comment: str = ''
    status_yang_mappings: StageStatus = StageStatus.NOTHING_TO_DO
    status_offer_prioritization: StageStatus = StageStatus.NOTHING_TO_DO
    counters: Dict[str, int] = field(default_factory=dict)


@dataclass
class StorageUrl:
    permalink: uint = field(default=0, metadata={'is_key': True, 'foreign_key': StoragePermalink.id})
    provider: str = field(default='', metadata={'is_key': True})
    url: str = field(default='', metadata={'is_key': True})


STORAGE_ENTITY = Union[Type[StoragePermalink], Type[StoragePermaroom], Type[StorageMapping], Type[StorageUrl]]

TABLE_NAMES = {
    'permalinks': StoragePermalink,
    'permarooms': StoragePermaroom,
    'mappings': StorageMapping,
    'urls': StorageUrl,
}
