# -*- coding: utf-8 -*-
from __future__ import annotations

import logging
import random

from travel.hotels.content_manager.data_model.stage import CallCenterData, CallCenterDataOutputResult
from travel.hotels.content_manager.lib.common import dc_from_dict, dc_to_dict, get_dc_yt_schema
from travel.hotels.content_manager.lib.processor import Processor


LOG = logging.getLogger(__name__)


class MockCallCenter(Processor):

    @staticmethod
    def rand_bool(probability: float):
        return random.random() < probability

    def set_call_center_request_result(self, task: CallCenterData) -> None:

        if self.rand_bool(.8):
            result_request = CallCenterDataOutputResult.IN_PROCESS
            task.output.request_id = random.randint(0, 10000)
        else:
            result_request = CallCenterDataOutputResult.FAILED
        task.output.result = result_request

    def set_call_center_check_request_result(self, task: CallCenterData) -> None:
        if self.rand_bool(.8):
            result_check_request = CallCenterDataOutputResult.IN_PROCESS
        elif self.rand_bool(.8):
            result_check_request = CallCenterDataOutputResult.SUCCESS_WITH_CALL
        elif self.rand_bool(.8):
            result_check_request = CallCenterDataOutputResult.SUCCESS_WITHOUT_CALL
        else:
            result_check_request = CallCenterDataOutputResult.FAILED
        task.output.result = result_check_request

    def run(self):
        LOG.info(f'Processing {self.input_path}')
        random.seed()
        input_table = self.persistence_manager.join(self.input_path, 'assignments')
        output_table = self.persistence_manager.join(self.output_path, 'assignments')

        output_data = list()

        for row in self.persistence_manager.read(input_table):
            task: CallCenterData = dc_from_dict(CallCenterData, row)
            if task.input.request_id is None:
                self.set_call_center_check_request_result(task)
            else:
                self.set_call_center_request_result(task)
            output_data.append(dc_to_dict(task))

        LOG.info(f'Processed {len(output_data)} tasks')

        LOG.info(f'Write result to {output_table}')
        self.persistence_manager.write(output_table, output_data, get_dc_yt_schema(CallCenterData))

        LOG.info('All done')
