# -*- coding: utf-8 -*-
from __future__ import annotations

from typing import Iterable
import logging

from travel.hotels.content_manager.data_model.stage import CallCenterData
from travel.hotels.content_manager.data_model.stage import CallCenterDataInput, CallCenterDataOutput
from travel.hotels.content_manager.data_model.storage import StoragePermalinkWL
from travel.hotels.content_manager.data_model.options import TriggerOptions
from travel.hotels.content_manager.lib.attributes import Attributes
from travel.hotels.content_manager.lib.common import dc_to_dict, get_dc_yt_schema
from travel.hotels.content_manager.lib.storage import Storage
from travel.hotels.content_manager.lib.trigger import EntityGroupingKey, Producer, ThreadFilter, Trigger


LOG = logging.getLogger(__name__)


class ProducerCallCenter(Producer):

    def prepare_data(
            self,
            trigger: Trigger,
            thread_filter: ThreadFilter,
            local_storage: Storage,
            path: str,
            entities: Iterable[StoragePermalinkWL],
            grouping_key: EntityGroupingKey,
            options: TriggerOptions,
    ):
        LOG.info('Preparing trigger data')
        task_data = list()

        for permalink in entities:
            LOG.debug(permalink)

            if permalink.comments is None:
                permalink.comments = ''
            required_attributes = sorted(a.value for a in Attributes.get_attributes_to_check(permalink))

            ccd_input = CallCenterDataInput(
                request_id=permalink.call_center_request_id,
                permalink=permalink.permalink,
                required_attributes=required_attributes,
                comments=permalink.comments,
            )
            ccd = CallCenterData(
                input=ccd_input,
                output=CallCenterDataOutput(),
            )
            task_data.append(dc_to_dict(ccd))

        hotels_table = trigger.persistence_manager.join(path, 'assignments')
        LOG.info(f'Writing result to {hotels_table}')
        trigger.persistence_manager.write(hotels_table, task_data, get_dc_yt_schema(CallCenterData))

        trigger.write_options(options, hotels_table, grouping_key)
