# -*- coding: utf-8 -*-
from __future__ import annotations

import logging

from travel.hotels.content_manager.data_model.storage import StoragePermalink
from travel.hotels.content_manager.lib.common import dc_from_dict
from travel.hotels.content_manager.lib.updater import Updater


LOG = logging.getLogger(__name__)


class UpdaterCrKnownPermalinks(Updater):

    def run(self, output_path: str, temp_dir: str) -> None:
        new_permalinks_table = self.persistence_manager.join(output_path, 'permalinks')
        temp_permalinks_table = self.persistence_manager.join(output_path, 'permalinks_temp')
        storage_permalinks_table = self.path_info.storage_permalinks_table

        LOG.info(f'Reading permalinks from {new_permalinks_table}')
        raw_permalinks = self.persistence_manager.read(new_permalinks_table)

        permalinks = list()
        for raw_permalink in raw_permalinks:
            permalink = dc_from_dict(StoragePermalink, raw_permalink)
            permalinks.append(permalink)

        self.send_to_stage(StoragePermalink, permalinks, 'update_mappings')

        LOG.info('Adding permalinks to storage')
        self.persistence_manager.request_upsert(
            src_data=permalinks,
            dst_path=storage_permalinks_table,
            dc=StoragePermalink,
        )

        LOG.info(f'Removing {temp_permalinks_table}')
        self.persistence_manager.delete(temp_permalinks_table)
