# -*- coding: utf-8 -*-
from __future__ import annotations

import logging
import random

from travel.hotels.content_manager.data_model.storage import StorageMapping
from travel.hotels.content_manager.lib.common import dc_from_dict, dc_to_dict, get_dc_yt_schema
from travel.hotels.content_manager.lib.processor import Processor


LOG = logging.getLogger(__name__)


class MockOfferPrioritization(Processor):

    def run(self):
        LOG.info(f'Processing {self.input_path}')
        random.seed()

        input_table = self.persistence_manager.join(self.input_path, 'mappings')
        keep_table = self.persistence_manager.join(self.output_path, 'mappings_to_keep')
        remove_table = self.persistence_manager.join(self.output_path, 'mappings_to_remove')

        mappings = [dc_from_dict(StorageMapping, m) for m in self.persistence_manager.read(input_table)]

        keep = []
        remove = []

        for mapping in mappings:
            if random.randint(0, 1) == 0:
                remove.append(mapping)
            else:
                keep.append(mapping)

        keep = [dc_to_dict(item) for item in keep]
        remove = [dc_to_dict(item) for item in remove]

        self.persistence_manager.write(keep_table, keep, get_dc_yt_schema(StorageMapping))
        self.persistence_manager.write(remove_table, remove, get_dc_yt_schema(StorageMapping))
