# -*- coding: utf-8 -*-
from __future__ import annotations

import logging

from travel.hotels.content_manager.data_model.storage import StorageMapping
from travel.hotels.content_manager.lib.common import dc_from_dict, dc_to_dict
from travel.hotels.content_manager.lib.updater import Updater

LOG = logging.getLogger(__name__)


class UpdaterOfferPrioritization(Updater):

    def run(self, output_path: str, temp_dir: str) -> None:
        LOG.info('Getting processor results')

        keep_table = self.persistence_manager.join(output_path, 'mappings_to_keep')
        remove_table = self.persistence_manager.join(output_path, 'mappings_to_remove')

        mappings_to_remove = list(self.persistence_manager.read(remove_table))
        self.persistence_manager.request_remove(
            to_remove=mappings_to_remove,
            remove_from=self.path_info.storage_mappings_table,
            dc=StorageMapping,
        )

        mappings = [dc_from_dict(StorageMapping, m) for m in self.persistence_manager.read(keep_table)]

        self.mark_as_processed(StorageMapping, mappings)
        self.send_to_stage(StorageMapping, mappings, 'yang_mappings')

        mappings_to_keep = [dc_to_dict(item) for item in mappings]

        LOG.info('Updating storage mappings status')
        self.persistence_manager.request_upsert(
            src_data=mappings_to_keep,
            dst_path=self.path_info.storage_mappings_table,
            dc=StorageMapping,
            fields_to_update=list(self.fields_to_update[StorageMapping])
        )
