# -*- coding: utf-8 -*-
from __future__ import annotations

import logging

from travel.hotels.content_manager.data_model.storage import StorageMapping, StoragePermalink, StorageUrl
from travel.hotels.content_manager.lib.storage import Storage
from travel.hotels.content_manager.lib.updater import Updater


LOG = logging.getLogger(__name__)

ENTITIES_TO_PROCESS = (
    StoragePermalink,
    StorageMapping,
    StorageUrl,
)


class UpdaterPartnerOffers(Updater):

    def run(self, output_path: str, temp_dir: str) -> None:
        LOG.info('Getting processor results')
        local_storage = Storage()

        table_data = self.get_table_data(output_path, ENTITIES_TO_PROCESS)
        local_storage.apply_data(table_data)

        self.mark_as_processed(StoragePermalink, (p for p in local_storage.permalinks.values()))
        permalinks_to_send = (
            p for p in local_storage.permalinks.values()
            if local_storage.get_permalink_other_mappings(p)
        )
        self.send_to_stage(StoragePermalink, permalinks_to_send, 'yang_rooms')

        self.add_fields_to_update(StoragePermalink, ['hotel_url'])

        LOG.info('Update storage permalinks status')
        self.update_storage_entity(local_storage.get_entity_data(StoragePermalink), StoragePermalink)

        LOG.info('Add mappings to storage')
        self.persistence_manager.request_upsert(
            src_data=local_storage.get_entity_data(StorageMapping),
            dst_path=self.path_info.storage_mappings_table,
            dc=StorageMapping,
        )

        LOG.info('Add urls to storage')
        self.persistence_manager.request_upsert(
            src_data=local_storage.get_entity_data(StorageUrl),
            dst_path=self.path_info.storage_urls_table,
            dc=StorageUrl,
        )
