# -*- coding: utf-8 -*-

import logging

from travel.hotels.content_manager.lib.processor import Processor

LOG = logging.getLogger(__name__)


class ProcessorSCExportDescriptions(Processor):

    def run(self) -> None:
        descriptions_path = self.path_info.storage_sc_descriptions_table
        export_path = self.options.export_path
        LOG.info(f'Exporting descriptions from {descriptions_path} to {export_path}')

        query = f'''
            INSERT INTO `{export_path}` WITH TRUNCATE
            SELECT
                carrier_code,
                car_type_code,
                sc_code,
                data_source,
                sc_description,
                sc_description_original,
                sc_description_specific,
            FROM `{descriptions_path}`
            WHERE sc_description_result IN ("actual", "updated")
        '''

        self.yql_client.run_query(query)
        LOG.info('All done')
