import logging

from travel.hotels.content_manager.lib.processor import Processor

LOG = logging.getLogger(__name__)


class ProcessorSCNewDescriptions(Processor):

    def run(self) -> None:
        input_descriptions = self.persistence_manager.join(self.input_path, 'descriptions')
        output_descriptions = self.persistence_manager.join(self.output_path, 'descriptions')

        LOG.info(f'Copying descriptions table from {input_descriptions} to {output_descriptions}')
        self.persistence_manager.copy(input_descriptions, output_descriptions)
