# -*- coding: utf-8 -*-
from __future__ import annotations

from typing import List
import logging

from travel.hotels.content_manager.data_model.storage import StorageSCDescription
from travel.hotels.content_manager.data_model.stage import SCNewDescriptionData
from travel.hotels.content_manager.lib.common import dc_from_dict, dc_to_dict
from travel.hotels.content_manager.lib.updater import Updater


LOG = logging.getLogger(__name__)


class UpdaterSCNewDescriptions(Updater):

    def get_descriptions(self, output_path: str) -> List[StorageSCDescription]:
        descriptions = list()

        descriptions_table = self.persistence_manager.join(output_path, 'descriptions')
        LOG.info(f'Reading descriptions from {descriptions_table}')
        raw_descriptions = self.persistence_manager.read(descriptions_table)

        for raw_permalink in raw_descriptions:
            data: SCNewDescriptionData = dc_from_dict(SCNewDescriptionData, raw_permalink)
            LOG.info(data)
            description = StorageSCDescription(
                carrier_code=data.carrier_code,
                car_type_code=data.car_type_code,
                sc_code=data.sc_code,
            )
            descriptions.append(description)

        return descriptions

    def run(self, output_path: str, temp_dir: str) -> None:
        descriptions = self.get_descriptions(output_path)
        self.send_to_stage(StorageSCDescription, descriptions, 'sc_update_descriptions', delay=0)

        raw_descriptions = [dc_to_dict(d) for d in descriptions]
        LOG.info('Adding descriptions to storage')
        self.update_storage_entity(raw_descriptions, StorageSCDescription)
