# -*- coding: utf-8 -*-
from __future__ import annotations

import logging

from travel.hotels.content_manager.data_model.storage import StoragePermalink
from travel.hotels.content_manager.data_model.stage import PopularHotelsData
from travel.hotels.content_manager.lib.common import dc_to_dict
from travel.hotels.content_manager.lib.updater import Updater


LOG = logging.getLogger(__name__)


class UpdaterTopPermalinks(Updater):

    def run(self, output_path: str, temp_dir: str) -> None:
        new_permalinks_table = self.persistence_manager.join(output_path, 'permalinks')
        storage_permalinks_table = self.persistence_manager.join(self.path_info.storage_path, 'permalinks')

        LOG.info(f'Reading popular hotels from {new_permalinks_table}')
        raw_hotels = self.persistence_manager.read(new_permalinks_table)

        permalinks = list()
        for raw_hotel in raw_hotels:
            hotel = PopularHotelsData(**raw_hotel)
            permalink = StoragePermalink(
                id=hotel.permalink,
            )
            LOG.debug(permalink)
            permalinks.append(permalink)

        self.send_to_stage(StoragePermalink, permalinks, 'partner_offers')

        raw_permalinks = [dc_to_dict(p) for p in permalinks]
        LOG.info('Adding permalinks to storage')
        self.persistence_manager.request_upsert(
            src_data=raw_permalinks,
            dst_path=storage_permalinks_table,
            dc=StoragePermalink,
        )
