# -*- coding: utf-8 -*-
from __future__ import annotations

import logging
import random

from travel.hotels.content_manager.data_model.storage import StorageMapping
from travel.hotels.content_manager.lib.common import get_dc_yt_schema

from travel.hotels.content_manager.stages_common.mock_partner_offers import MockPartnerOffers

LOG = logging.getLogger(__name__)


class MockUpdateMappings(MockPartnerOffers):

    def run(self):
        LOG.info(f'Processing {self.input_path}')
        random.seed()

        operators = [o['OperatorId'] for o in self.persistence_manager.read('//home/travel/prod/config/operators')]

        input_permalinks_table = self.persistence_manager.join(self.input_path, 'permalinks')

        output_permalinks_table = self.persistence_manager.join(self.output_path, 'permalinks')
        output_mappings_table = self.persistence_manager.join(self.output_path, 'mappings')

        known_mappings = self.get_known_mappings()
        LOG.info(f'Got {len(known_mappings)} known mappings')

        input_permalinks = self.get_input_permalink_ids(input_permalinks_table)
        LOG.info(f'Got {len(input_permalinks)} input permalinks')

        new_mappings = self.get_new_mappings(input_permalinks, known_mappings, operators)
        LOG.info(f'Got {len(new_mappings)} new mappings')

        LOG.info(f'Copying permalinks from {input_permalinks_table} to {output_permalinks_table}')
        self.persistence_manager.copy(input_permalinks_table, output_permalinks_table)

        LOG.info(f'Writing mappings to {output_mappings_table}')
        self.persistence_manager.write(output_mappings_table, new_mappings, get_dc_yt_schema(StorageMapping))

        LOG.info('All done')
