# -*- coding: utf-8 -*-

# noinspection PyUnresolvedReferences
from datetime import date

from dateutil.relativedelta import relativedelta

from travel.hotels.content_manager.stages_common.processor_partner_offers import ProcessorPartnerOffers


class ProcessorUpdateMappings(ProcessorPartnerOffers):

    def clear_mappings(self, known_mappings_table, output_table):
        query = f'''
                USE hahn;
                PRAGMA SimpleColumns;

                INSERT INTO `{output_table}` WITH TRUNCATE
                SELECT
                    data.*
                FROM `{output_table}` as data
                LEFT ONLY JOIN `{known_mappings_table}` as info
                USING (permalink, mapping_key, orig_hotel_id, operator_id);
                '''
        self.yql_client.run_query(query)

    def run(self):
        # Input data
        input_permalinks_table = self.persistence_manager.join(self.input_path, 'permalinks')
        # Output data
        output_data_table = self.persistence_manager.join(self.output_path, 'mappings')
        output_permalinks_table = self.persistence_manager.join(self.output_path, 'permalinks')
        # Temporary data
        temp_hotel_ids_table = self.persistence_manager.join(self.output_path, 'hotel_ids_table')
        # Storage data

        self.get_hotel_ids(input_permalinks_table, temp_hotel_ids_table)

        self.scan_logs(
            hotel_ids_table=temp_hotel_ids_table,
            table_out=output_data_table,
            date_from=str(date.today() - relativedelta(months=1)),
            date_to=str(date.today()),
        )

        known_mappings = self.persistence_manager.join(self.path_info.storage_path, 'mappings')
        self.clear_mappings(known_mappings, output_data_table)
        self.persistence_manager.copy(input_permalinks_table, output_permalinks_table)

        if self.persistence_manager.exists(temp_hotel_ids_table):
            self.persistence_manager.delete(temp_hotel_ids_table)
