# -*- coding: utf-8 -*-
from __future__ import annotations

from typing import Iterable
import logging

from travel.hotels.content_manager.data_model.storage import StoragePermalink
from travel.hotels.content_manager.data_model.storage import EntityWithStatus
from travel.hotels.content_manager.data_model.options import TriggerOptions
from travel.hotels.content_manager.lib.common import dc_to_dict, get_dc_yt_schema
from travel.hotels.content_manager.lib.storage import Storage
from travel.hotels.content_manager.lib.trigger import EntityGroupingKey, Producer, ThreadFilter, Trigger

LOG = logging.getLogger(__name__)


class ProducerUpdateMappings(Producer):

    def prepare_data(
            self,
            trigger: Trigger,
            thread_filter: ThreadFilter,
            local_storage: Storage,
            path: str,
            entities: Iterable[EntityWithStatus],
            grouping_key: EntityGroupingKey,
            options: TriggerOptions,
    ):
        permalinks_table = trigger.persistence_manager.join(path, 'permalinks')
        permalinks = (dc_to_dict(p) for p in entities)
        LOG.info(f'Writing result to {permalinks_table}')
        trigger.persistence_manager.write(permalinks_table, permalinks, get_dc_yt_schema(StoragePermalink))

        trigger.add_storage_link_delayed(path)
