# -*- coding: utf-8 -*-
from __future__ import annotations

import logging

from travel.hotels.content_manager.data_model.storage import StorageMapping, StoragePermalink
from travel.hotels.content_manager.lib.storage import Storage
from travel.hotels.content_manager.lib.updater import Updater


LOG = logging.getLogger(__name__)

ENTITIES_TO_PROCESS = (
    StoragePermalink,
    StorageMapping,
)


class UpdaterUpdateMappings(Updater):

    def run(self, output_path: str, temp_dir: str) -> None:
        LOG.info('Getting processor results')
        local_storage = Storage()

        table_data = self.get_table_data(output_path, ENTITIES_TO_PROCESS)
        local_storage.apply_data(table_data)

        for permalink in local_storage.permalinks.values():
            mapping_keys_to_delete = list()
            for key, mapping in local_storage.get_permalink_other_mappings(permalink).items():
                if mapping.operator_id != 'OI_TRAVELLINE':
                    mapping_keys_to_delete.append(key)
            for key in mapping_keys_to_delete:
                local_storage.delete_other_mapping(key)

        self.mark_as_processed(StoragePermalink, (p for p in local_storage.permalinks.values()))
        mappings_to_send = (
            m
            for p in local_storage.permalinks.values()
            for m in local_storage.get_permalink_other_mappings(p).values()
        )
        self.send_to_stage(StorageMapping, mappings_to_send, 'offer_prioritization')

        LOG.info('Updating storage permalinks status')
        self.update_storage_entity(local_storage.get_entity_data(StoragePermalink), StoragePermalink)

        LOG.info('Updating storage mappings status')
        self.update_storage_entity(local_storage.get_entity_data(StorageMapping), StorageMapping)
