# -*- coding: utf-8 -*-
from __future__ import annotations

import logging
import random

from travel.hotels.content_manager.data_model.stage import WLMatchHotelsData
from travel.hotels.content_manager.lib.common import dc_from_dict, dc_to_dict, get_dc_yt_schema
from travel.hotels.content_manager.lib.processor import Processor


LOG = logging.getLogger(__name__)


class MockWLMatchHotels(Processor):

    @staticmethod
    def rand_bool(probability: float):
        return random.random() < probability

    def set_result(self, task: WLMatchHotelsData) -> None:
        task.output.result = 'double' if self.rand_bool(.85) else 'no_double'

    def run(self):
        LOG.info(f'Processing {self.input_path}')
        random.seed()

        input_table = self.persistence_manager.join(self.input_path, 'hotels')
        output_table = self.persistence_manager.join(self.output_path, 'hotels')

        raw_input = self.persistence_manager.read(input_table)

        output_data = list()

        for row in raw_input:
            task: WLMatchHotelsData = dc_from_dict(WLMatchHotelsData, row)
            self.set_result(task)
            output_data.append(dc_to_dict(task))

        LOG.info(f'Processed {len(output_data)} hotels')

        LOG.info(f'Write result to {output_table}')
        self.persistence_manager.write(output_table, output_data, get_dc_yt_schema(WLMatchHotelsData))

        LOG.info('All done')
