import logging

from travel.hotels.content_manager.lib.processor import Processor

LOG = logging.getLogger(__name__)


class ProcessorWLStart(Processor):

    def run(self) -> None:
        input_permalinks = self.persistence_manager.join(self.input_path, 'permalinks')
        output_permalinks = self.persistence_manager.join(self.output_path, 'permalinks')

        LOG.info(f'Copying permalinks table from {input_permalinks} to {output_permalinks}')
        self.persistence_manager.copy(input_permalinks, output_permalinks)
