# -*- coding: utf-8 -*-
from __future__ import annotations

import logging
import random

from travel.hotels.content_manager.data_model.stage import WLNewHotelsHotelData, WLNewHotelsPermalinkData
from travel.hotels.content_manager.lib.common import dc_from_dict, dc_to_dict, get_dc_yt_schema
from travel.hotels.content_manager.lib.processor import Processor


LOG = logging.getLogger(__name__)

PARTNER_ID_MAX = 10
ORIGINAL_ID_MAX = 2 ** 32 - 1


class MockWLGetHotels(Processor):

    def get_hotels(self):
        input_table = self.persistence_manager.join(self.input_path, 'permalinks')
        output_table = self.persistence_manager.join(self.output_path, 'hotels')

        hotels = list()
        for row in self.persistence_manager.read(input_table):
            permalink_data: WLNewHotelsPermalinkData = dc_from_dict(WLNewHotelsPermalinkData, row)
            hotel_data = WLNewHotelsHotelData(
                permalink=permalink_data.permalink,
                partner_id=f'partner_{random.randint(0, PARTNER_ID_MAX)}',
                original_id=str(random.randint(0, ORIGINAL_ID_MAX)),
                grouping_key=permalink_data.grouping_key,

            )
            hotels.append(dc_to_dict(hotel_data))

        self.persistence_manager.write(output_table, hotels, get_dc_yt_schema(WLNewHotelsHotelData))

    def run(self):
        random.seed()

        LOG.info(f'Processing {self.input_path}')
        self.get_hotels()

        input_permalinks_table = self.persistence_manager.join(self.input_path, 'permalinks')
        output_permalinks_table = self.persistence_manager.join(self.output_path, 'permalinks')
        LOG.info(f'Copying from {input_permalinks_table} to {output_permalinks_table}')
        self.persistence_manager.copy(input_permalinks_table, output_permalinks_table)

        input_failed_permalinks_table = self.persistence_manager.join(self.input_path, 'failed_permalinks')
        if self.persistence_manager.exists(input_failed_permalinks_table):
            output_failed_permalinks_table = self.persistence_manager.join(self.output_path, 'failed_permalinks')
            LOG.info(f'Copying from {input_failed_permalinks_table} to {output_failed_permalinks_table}')
            self.persistence_manager.copy(input_failed_permalinks_table, output_failed_permalinks_table)

        LOG.info('All done')
