# -*- coding: utf-8 -*-

from argparse import ArgumentParser
import logging.config

from yt.wrapper.client import YtClient

from travel.library.python.yandex_vault import resolve_secrets_ns
from travel.hotels.content_manager.lib.persistence_manager import YtCachePersistenceManager


def main():
    logging.basicConfig(level=logging.INFO)

    parser = ArgumentParser()
    parser.add_argument('--vault-token', default=None)
    parser.add_argument('--yt-proxy', default='hahn')
    parser.add_argument('--yt-token', required=True)
    parser.add_argument('--src-path', required=True)
    parser.add_argument('--slice-size', type=int, required=True)

    options = parser.parse_args()
    resolve_secrets_ns(options)

    yt_client = YtClient(proxy=options.yt_proxy, token=options.yt_token)

    persistence_manager = YtCachePersistenceManager(yt_client, None)

    src_path = options.src_path
    dst_dir = src_path + '_sliced'

    if persistence_manager.exists(dst_dir):
        logging.info(f'Removing existing {dst_dir}')
        persistence_manager.delete(dst_dir)

    schema = {
        'permalink': 'uint64',
    }

    slice_size = options.slice_size
    slice_index = 0
    data_slice = list()
    for row in persistence_manager.read(src_path):
        data_slice.append(row)

        if len(data_slice) < slice_size:
            continue

        dst_path = persistence_manager.join(dst_dir, f'slice_{slice_index}')
        logging.info(f'Writing {dst_path}')
        persistence_manager.write(dst_path, data_slice, schema)
        slice_index += 1
        data_slice = list()

    if data_slice:
        dst_path = persistence_manager.join(dst_dir, f'slice_{slice_index}')
        logging.info(f'Writing {dst_path}')
        persistence_manager.write(dst_path, data_slice, schema)


if __name__ == '__main__':
    main()
