# -*- coding: utf-8 -*-

from argparse import ArgumentParser

from yt.wrapper.client import YtClient

from travel.library.python.yandex_vault import resolve_secrets_ns
from travel.hotels.content_manager.data_model.storage import StorageMapping, StoragePermalink, StoragePermaroom
from travel.hotels.content_manager.data_model.storage import StorageUrl
from travel.hotels.content_manager.lib.persistence_manager import YtPersistenceManager
from travel.hotels.content_manager.lib.storage import Storage
from travel.hotels.content_manager.lib.yql_simple_client import YqlSimpleClient


def update_storage(pm, storage_from, storage_to):
    print('Update storage permalinks')
    pm.request_upsert(
        src=storage_from.permalinks_path,
        dst=storage_to.permalinks_path,
        dc=StoragePermalink,
    )

    print('Update storage permarooms')
    pm.request_upsert(
        src=storage_from.permarooms_path,
        dst=storage_to.permarooms_path,
        dc=StoragePermaroom,
    )

    print('Update storage mappings')
    pm.request_upsert(
        src=storage_from.mappings_path,
        dst=storage_to.mappings_path,
        dc=StorageMapping,
    )

    print('Update storage urls')
    pm.request_upsert(
        src=storage_from.urls_path,
        dst=storage_to.urls_path,
        dc=StorageUrl,
    )


def main():
    parser = ArgumentParser()
    parser.add_argument('--vault-token', default=None)

    parser.add_argument('--path-from', required=True)
    parser.add_argument('--path-to', required=True)

    parser.add_argument('--yt-proxy', default='hahn')
    parser.add_argument('--yt-token', required=True)

    parser.add_argument('--yql-token', required=True)

    options = parser.parse_args()
    resolve_secrets_ns(options)

    yt_client = YtClient(proxy=options.yt_proxy, token=options.yt_token)
    yql_client = YqlSimpleClient(token=options.yql_token, yt_proxy=options.yt_proxy)
    pm = YtPersistenceManager(yt_client, yql_client)
    storage_from = Storage(pm, options.path_from)
    storage_to = Storage(pm, options.path_to)

    with pm.transaction() as transaction:
        yql_client.transaction_id = transaction.transaction_id
        update_storage(pm, storage_from, storage_to)
        yql_client.transaction_id = None


if __name__ == '__main__':
    main()
