exports.Task = extend(TolokaHandlebarsTask, function (options) {
  TolokaHandlebarsTask.call(this, options);
}, {

    validate: function(solution) {
        let output = solution.output_values;
        let result = output.result;

        if (result === 'success') {

            let successConditions = [
                'success_no_duplicate',
                'success_mini_cards_ok',
                'success_platinum_ok',
                'success_hotel_rubric_ok',
                'success_publish_status_ok',
                'success_tech_type_ok',
            ];

            let allSelected = successConditions.every(function (key) {
                return output[key]
            });

            if (!allSelected) {
                return {
                    task_id: this.getTask().id,
                    errors: {
                        '__TASK__': {
                            message: 'Не все пункты проверены'
                        }
                    }
                }
            }
        }
        else if (result === 'in_process') {

            let inProcessConditions = [
                'in_process_platinum_add',
                'in_process_platinum_delete',
                'in_process_merge',
                'in_process_chain_unification',
                'in_process_tycoon',
                'in_process_check_duplicates',
                'in_process_other',
            ];

            let someSelected = inProcessConditions.some(function (key) {
                return output[key]
            });

            if (!(someSelected && output.in_process_comments)) {
                return {
                    task_id: this.getTask().id,
                    errors: {
                        '__TASK__': {
                            message: 'Нужно выбрать хотя бы один вариант и заполнить комментарий'
                        }
                    }
                }
            }
        }
        else if (result === 'failed') {

            let failedReasons = [
                'failed_unpublished',
                'failed_call_center',
                'failed_no_hotel_rubric',
                'failed_other',
            ];

            let someSelected = failedReasons.some(function (key) {
                return output[key]
            });

            if (!someSelected) {
                return {
                    task_id: this.getTask().id,
                    errors: {
                        '__TASK__': {
                            message: 'Нужно выбрать хотя бы один вариант'
                        }
                    }
                }
            }
        }
        return TolokaHandlebarsTask.prototype.validate.apply(this, arguments);
    },

    getHandler: function(radioButton) {
        let blockSelectors = {
            'success': '.success_controls',
            'in_process': '.in_process_controls',
            'failed': '.failed_controls',
        };

        let dom = this.getDOMElement();
        let blocks = {};
        let allBlocks = [];

        for (let [key, selector] of Object.entries(blockSelectors)) {
            let block = $(dom).find(selector);
            blocks[key] = block;
            allBlocks.push(block);
        }

        let input = $(radioButton).find('input')[0];
        let blockToShow = blocks[input.value];

        return {
            allBlocks: allBlocks,
            blockToShow: blockToShow,
            handleEvent(event) {
                for (let block of allBlocks) {
                    block.hide();
                }
                blockToShow.show();
            }
        }
    },

    onRender: function() {
        let dom = this.getDOMElement();
        let radioButtons = dom.getElementsByClassName('field field_type_radio');
        for (let radioButton of radioButtons) {
            radioButton.addEventListener('click', this.getHandler(radioButton))
        }
    },

    onDestroy: function() {
    // Задание завершено, можно освобождать (если были использованы) глобальные ресурсы
    }
});

function extend(ParentClass, constructorFunction, prototypeHash) {
  constructorFunction = constructorFunction || function () {};
  prototypeHash = prototypeHash || {};
  if (ParentClass) {
    constructorFunction.prototype = Object.create(ParentClass.prototype);
  }
  for (var i in prototypeHash) {
    constructorFunction.prototype[i] = prototypeHash[i];
  }
  return constructorFunction;
}
