exports.Task = extend(TolokaHandlebarsTask, function (options) {
  TolokaHandlebarsTask.call(this, options);
    if (Number(this.getTask().id) === 0) 
      {
      var markup = options.specs.view_spec.markup;
      this.template = this.compile(markup);
    }
}, {
    validate: function(solution) {
        var isSelected = solution.output_values['result2'];

        if (!isSelected) {
            return {
                task_id: this.getTask().id,
                errors: {
                    '__TASK__': {
                        message: 'Задание не выполнено'
                    }
                }
            };
        } else {
            return TolokaHandlebarsTask.prototype.validate.apply(this, arguments);
        }
    },
    setSolution: function(solution) {
        this.getDOMElement().querySelector('.second-scale.results2-IP').style.display = solution.output_values.result2 === 'IP' ? 'block' : 'none';
        this.getDOMElement().querySelector('.second-scale.results2-legal').style.display = solution.output_values.result2 === 'legal' ? 'block' : 'none';
      
        TolokaHandlebarsTask.prototype.setSolution.call(this, solution);
    },
    onRender: function() {
    },
  onDestroy: function() {
    // Задание завершено, можно освобождать (если были использованы) глобальные ресурсы
  },
});

function extend(ParentClass, constructorFunction, prototypeHash) {
  constructorFunction = constructorFunction || function () {};
  prototypeHash = prototypeHash || {};
  if (ParentClass) {
    constructorFunction.prototype = Object.create(ParentClass.prototype);
  }
  for (var i in prototypeHash) {
    constructorFunction.prototype[i] = prototypeHash[i];
  }
  return constructorFunction;
}
