exports.Task = extend(TolokaHandlebarsTask, function (options) {
  TolokaHandlebarsTask.call(this, options);
    if (Number(this.getTask().id) === 0)
      {
      var markup = options.specs.view_spec.markup;
      this.template = this.compile(markup);
    }
}, {
    validate: function(solution) {
        console.log('Running validate');
        var isIlliterate = !solution.output_values['result'] || solution.output_values['result2'],
            errorSelected = solution.output_values['result'] || !solution.output_values['result2'],
            allSelected = !solution.output_values['result'] || !solution.output_values['result2'];

        if (isIlliterate && errorSelected && allSelected) {
            return {
                task_id: this.getTask().id,
                errors: {
                    '__TASK__': {
                        message: 'Задание не выполнено'
                    }
                }
            };
        } else {
            return TolokaHandlebarsTask.prototype.validate.apply(this, arguments);
        }
    },

    setSolution: function(solution) {
        console.log('Running setSolution');
        var secondScale = this.getDOMElement().querySelector('.second-scale');

        if (secondScale) {
            secondScale.style.display = solution.output_values.result2 === 'no' ? 'block' : 'none';
        }

        TolokaHandlebarsTask.prototype.setSolution.call(this, solution);
    },

    onRender: function() {
        console.log('Running onRender');
    },

  onDestroy: function() {
    // Задание завершено, можно освобождать (если были использованы) глобальные ресурсы
  }
});

function extend(ParentClass, constructorFunction, prototypeHash) {
  constructorFunction = constructorFunction || function () {};
  prototypeHash = prototypeHash || {};
  if (ParentClass) {
    constructorFunction.prototype = Object.create(ParentClass.prototype);
  }
  for (var i in prototypeHash) {
    constructorFunction.prototype[i] = prototypeHash[i];
  }
  return constructorFunction;
}
