exports.Task = extend(TolokaHandlebarsTask, function (options) {
    TolokaHandlebarsTask.call(this, options);
    this.List = []
}, {
    initialValues: {},

    saveResult: function (event) {
        console.log('Running saveResult');

        let resultPermarooms = [];
        let count = 0;
        let elements = Array.from(this.getDOMElement()
            .querySelector('.workspace')
            .querySelectorAll('.item'));

        elements.forEach(element => {
            if ($(element).hasClass('itemDeleted')) {
                return  // skip element
            }
            count = count + 1;

            let permaroom = this.initialValues[element.id] || {'permaroom_id': null};

            let permaroomFields = Array.from(element.querySelectorAll('input, textarea'));
            permaroomFields.forEach(field => {
                let name = field.name.match(/^(.*)__/)[1];
                permaroom[name] = field.type === 'checkbox' ? field.checked : field.value;

                let placeholderParts = field.placeholder.split(/\d/);
                placeholderParts[0] = placeholderParts[0] + count;
                field.placeholder = placeholderParts.join('');
            });
            permaroom.id = element.id;
            resultPermarooms.push(permaroom);
        });

        this.setSolutionOutputValue('result_permarooms', resultPermarooms);
    },

    onRender: function () {
        console.log('Running onRender');
        // DOM-элемент задания сформирован (доступен через #getDOMElement())
        let microTask = this.getDOMElement(),
            output = this.getSolution().output_values;
        let input = this.getTask().input_values;

        if (input.available_permarooms && input.available_permarooms.length > 0) {
            $(microTask).find('.availablePermarooms').show()
        }

        microTask.querySelector('.addBlock').addEventListener('click', this.addBlock.bind(this));
        $(microTask).find('.operator_id').on('click', this.offers_item.bind(this));
        $(microTask).find('.reset_filter').on('click', function () {
            $(this.getDOMElement().querySelector('.offers')).find('.offers_item').show();
            $(this.getDOMElement()).find('.reset_filter').hide()

        }.bind(this));

        if (output.result_permarooms) {
            output.result_permarooms.forEach(it => {
                this.addBlock(it)
            })
        }

        input.available_permarooms.forEach(it => {
            this.addBlock(it)
        });
    },

    offers_item: function (event) {
        console.log('Running offers_item');
        let target = $(event.currentTarget).text();
        $(this.getDOMElement()).find('.reset_filter').show();
        let items = Array.from(this.getDOMElement().querySelector('.offers').querySelectorAll('.offers_item'));
        items.forEach(it => {
            let ite = it.querySelector('.operator_id');
            if ($(ite).text() === target) {

            } else {
                $(it).hide()
            }
        })
    },

    addError: function (message, field, errors) {
        console.log('Running addError');
        errors || (errors = {
            task_id: this.getOptions().task.id,
            errors: {}
        });
        errors.errors[field] = {
            message: message
        };

        return errors;
    },

    validate: function (solution) {
        console.log('Running validate');
        let errors = null;
        this.saveResult();
        let allResultPermarooms = solution.output_values.result_permarooms;

        if (!allResultPermarooms || !allResultPermarooms[0]) {
            return
        }

        allResultPermarooms.forEach(resultPermaroom => {
            if ((resultPermaroom.permaroom_name) || (resultPermaroom.deleted)) {
                return // skip permaroom
            }
            errors = this.addError(
                'Необходимо заполнить все названия типа номера! (Ненужные карточки можно удалить)',
                '__TASK__',
                errors
            );
        });

        if (errors) {
            console.log(errors);
            return errors
        }

        let existentResultPermarooms = allResultPermarooms.filter(function (item) {
            return !item.deleted
        });

        let resultPermarooms = existentResultPermarooms.map(function (item) {
            delete item.id;
            delete item.deleted;
            return item
        });

        this.setSolutionOutputValue('result_permarooms', resultPermarooms);
        console.log(solution.output_values.result_permarooms);
        return errors
    },

    removeBlock: function (event) {
        console.log('Running removeBlock');
        let target = event.currentTarget.closest(".item");
        let restor = {};
        let items = Array.from(this.getDOMElement().querySelector('.workSpace').querySelectorAll('.item:not(.itemDeleted)')).length;
        Array.from(target.querySelectorAll('input, textarea')).forEach(field => {
            let name = field.name.match(/^(.*)__/)[1];
            switch (field.type) {
                case 'text':
                case 'textarea':
                    restor[name] = field.value;
                    break;
                case 'checkbox':
                    restor[name] = field.checked;
                    break;
            }
        });
        if (items > 1) {
            $(target).addClass('itemDeleted');
        } else {
            $(target).addClass('itemDeleted');
            this.addBlock()
        }

        this.saveResult();
    },

    addBlock: function (data = null) {
        console.log('Running addBlock');
        let microTask = this.getDOMElement(),
            itemId = data && data.id || this.generateId(),
            itemTemplate = microTask.querySelector('.item_template').innerHTML;
        microTask.querySelector('.workspace').insertAdjacentHTML('beforeEnd', itemTemplate); //beforeEnd

        let trg = Array.from(microTask.querySelector(".workspace").querySelectorAll(`.item`));
        var item = trg[(trg.length - 1)];
        item.id = itemId;
        let permaroomControls = Array.from(item.querySelectorAll('input, textarea'));

        if (data && !data.target) {
            data.permaroom_id = data.permaroom_id || null;
            this.initialValues[itemId] = data
        }

        permaroomControls.forEach(control => {
            $(control).on('input', function () {this.saveResult()}.bind(this));

            var placeholder = control.placeholder.split('номера');
            placeholder[0] = placeholder[0] + " номера " + "0" + " ";
            control.placeholder = placeholder.join('');
            let name = control.name.split("__")[0];

            if (data && data[name]) {
                switch (control.type) {
                    case 'text':
                    case 'textarea':
                        control.value = data[name];
                        break;
                    case 'checkbox':
                        control.checked = data[name];
                        break;
                }
            }

            control.name += itemId;
            control.id = itemId;
        });

        if (!permaroomControls[0].value) {
            $(permaroomControls[1]).attr('disabled', 'disabled');
            $(permaroomControls[2]).attr('disabled', 'disabled');
        }

        $(permaroomControls[0]).on('input', function (e) {
            let trg = e.currentTarget;
            if (trg.value) {
                $(trg.closest('.item')).find('textarea').attr('disabled', false)
            }
        });

        $(item.querySelector('.trash')).on('click', this.removeBlock.bind(this));

        this.saveResult();
        $(item.querySelector("textarea")).focus();
    },

    setSolution: function (solution) {
        console.log('Running setSolution');
    },

    generateId: function () {
        console.log('Running generateId');
        let s = [];
        let hexDigits = '0123456789abcdef';

        for (let i = 0; i <= 36; i++) {
            s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
        }

        s[14] = '4';
        s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1);

        return s.join('');
    },

    onDestroy: function () {
        // Задание завершено, можно освобождать (если были использованы) глобальные ресурсы
    }
});

function extend(ParentClass, constructorFunction, prototypeHash) {
    constructorFunction = constructorFunction || function () {
    };
    prototypeHash = prototypeHash || {};
    if (ParentClass) {
        constructorFunction.prototype = Object.create(ParentClass.prototype);
    }
    for (var i in prototypeHash) {
        constructorFunction.prototype[i] = prototypeHash[i];
    }
    return constructorFunction;
}
