/*  Версия Шаблона Всевластия: 2.09 от 17.02.2020
    Документация: http://шаблон.фанфрог.рф
*/
/* Настройки шаблона */
window.theOneSettings = {
  verticalSuite: true, //----Расположить таски вертикально или горизонтально? (с листалкой)
  fullScreenMode: false, //--Полноэкранный режим шаблона. verticalSuite должен быть false, .task и .block.main растягиваются на весь экран, заголовок .block.main закрепляется сверху.
  taskSwitcher: true, //-----Отображать ли листалку тасков? (в правом верхнем углу первого блока каждого таска)
  taskCounter: true, //------Отображать ли счётчик тасков в листалке?
  taskList: true, //---------Отображать ли список тасков при наведении на листалку?
  taskMinimizer: true, //---Включить ли возможность для толокера сворачивать блоки/таски в шаблоне? (визуальщина)
  hotkeysEnabled: true, //---Включены ли горячие клавиши (если нет - стрелочки на клавиатуре просто листают таски)
  useSpecMapper: true, //----Включён ли маппер выходной спеки.
  printSolution: false, //---Выводить ли в консоль выходную солюшку и входную спеку (помогает при валидации, выключить для прода!)
  notForDirect: true, //-----Этот шаблон - не для Директа?
  useComplainter: false, //---Использовать ли библиотеку жалобщика? (настройки ниже)
  useGlossarySearch: false,//-Использовать ли библиотеку поиска по глоссарию? (настройки ниже)
  actionLogger: false, //----Логировать ли все дейсвтия в шаблоне для замера метрик и статистики?
  contextMenu: false, //-----Использовать ли своё кастомизируемое контекстное меню шаблона?
  usingOneRawData: false, //----Присутствует ли в выходной спеке поле __theOneRawData? В это поле сохранится вся ШВшная солюшка для 100% работоспособности режимов просмотра выполненных заданий.
  /* Второстепенные настройки */
  //Шаблон
  timeToOpenHintByKey: 500, //Если зажать горячую клавишу элемента с подсказкой (hint или help) больше этого времени в миллисекундах - вместо активации откроется подсказка.
  elementButtonsHotkeysOrderString: '1234567890QWERTYUIOPASDFGHJKLZXCVBNM', //Порядок назначения горячих клавиш кнопкам в каждом элементе (выбираемом с клавиатуры)
  customTitleElements: [], //Ваши собственные элементы в правой части заголовка шаблона
  //Библиотеки (грузятся только если включены выше)
  //jQuery UI (используется только библиотеками, сам по себе не грузится)
  jQueryUILibSrc: 'https://code.jquery.com/ui/1.12.1/jquery-ui.min.js',
  jQueryUICssSrc: 'https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css',
  //Жалобщик
  complainterLibSrc: 'https://support-templates.s3.yandex.net/yang_templates/0.0.68/Complaints.js',
  complainterProxyName: 'ya_requester_sportloto',
  complainterNamespace: 'my_complaints_namespace',
  complainterCauses: [{name: 'reason1', commentRequired: true}],
  complainterTranslations: {en: {reason1: 'Reason 1'}, ru: {reason1: 'Причина 1'}},
  //Поисковик по глоссарию
  glossarySearchLib: 'https://alex625051.github.io/jquery.glossSearch_1_2.js',
  glossarySearchSource: 'https://storage.mds.yandex.net/get-ang2-data/34170/cc5e2030-b975-443b-84b7-0b1094f7cb67',
  //Просмотрщик картинок
  imageViewerScalingStep: 0.01, //Шаг свободного масштабирования изображения во встроенном просмотрщике картинок
  imageViewerRotationStep: 0.0125, //Шаг свободного поворота изображения во встроенном просмотрщике картинок. Желательно, чтобы оно было делителем числа 1.
  imageViewerDoubleClickTime: 400, //Время в мс для выполнения двойного клика в просмотрщике картинок. По картинке для фуллскрина или по кнопкам (в т.ч. и с клавы!)
  //Директ
  misprintsContainers: ['.bannerTitle a', '.bannerText'] //Контейнеры, в которых будут выделяться миспринты (используй хелпер {{{misprints field}}} в HTML, где field - поле с массивом миспринтов во входной спеке.)
};

/* Маппер выходной спеки. Позволяет собрать выходную спеку из стандартной Толоковской и спеки Всевластия. Включается параметром выше. */
window.specMapper={
  result: {
    from: "result",
  },
  is_source_official: {
    from: "is_source_official",
    convert: ["strToBool"],
  },
  data_source: {
    from: "data_source"
  },
  sc_description_original: {
    from: "sc_description_original",
  },
  sc_description: {
    from: "sc_description",
    convert: ["function"],
    function: function(d) {
        if (!d) {return "";}
        return d;
    }
  },
  sc_description_specific: {
    from: "sc_description_specific",
    convert: ["function"],
    function: function(ds) {
        if (!ds) {return [];}
        return ds;
    }
  }
};

window.theOneSpec = {spec: {}, specByName: []};
/*      Описание всех полей шаблона. Редактируйте смело!      */
theOneSpec.spec.mainFields = [
  {
    "type": "radioGroup",
    "name" : "result",
    "buttons": [
      {
        "caption": "Верно",
        "name": "actual"
      },
      {
        "caption": "Невозможно актуализировать",
        "name": "no_data"
      },
      {
        "caption": "Необходимо исправить",
        "name": "updated",
        "properties": {
          "includes": ["otherFields"]
        }
      }
    ]
  },
  {
    "type": "group",
    "name": "otherFields",
    "flags": ["excluded"],
    "groupFields": [
      {
        "type": "radioGroup",
        "name" : "is_source_official",
        "title": "Описание с оффициального сайта?",
        "buttons": [
          {
            "caption": "Да",
            "name": "true",
          },
          {
            "caption": "Нет",
            "name": "false",
            "properties": {
              "includes": ["data_source_group"],
            }
          }
        ]
      },
      {
        "type": "group",
        "name": "data_source_group",
        "flags": ["excluded"],
        "groupFields": [
          {
            "type": "textarea",
            "placeholder" : "Сайт, на котором было найдено описание классов обслуживания",
            "name": "data_source",
          },
        ],
      },
      {
        "type": "textarea",
        "placeholder" : "Оригинал текста с описанием классов до корректировки",
        "name": "sc_description_original"
      },
      {
        "type": "textarea",
        "placeholder" : "Новое описание класса обслуживания",
        "name": "sc_description",
        "properties": {
          "includes": ["dataGroup"],
          "flags": ["optional"],
        }
      },
      {
        "type": "radioGroup",
        "title": "<hr /> Есть ли услуги, предоставляемые в некоторых поездах?",
        "name" : "defined_cars",
        "buttons": [
          {
            "caption": "Да",
            "name": "yes",
            "properties": {
              "includes": ["sc_description_specific"]
            }
          },
          {
            "caption": "Нет",
            "name": "no"
          }
        ]
      },
      {
        "type": "group",
        "name": "sc_description_specific",
        "flags": ["infinite", "excluded"],
        "groupFields": [
          {
            "type": "textarea",
            "title": "Список услуг, предоставляемый в некоторых поездах:",
            "name": "description"
          },
          {
            "type": "textarea",
            "title": "Перечень номеров поездов, в которых доступны эти услуги:",
            "placeholder" : "Указываем через разделитель |, пример: 737В|738А|739А",
            "name": "car_numbers"
          },
          {
            "type": "title",
            "caption": "<hr /> "
          }
        ]
      }
    ]
  }
];

//Здесь в контексте таска выполняются все манипуляции со входными данными. В том числе и подключаются JSONки. Ваши собственные / внешние и какие-либо другие лучше добавлять в theOneSpec.
window.setTemplateData = function(data) {
  this.theOneSpec = $.extend(true, {}, theOneSpec);

  // удаляем флаг excluded у dataGroup, если sc_description пустой
  for (const jsonName in this.theOneSpec.spec) {
    const thisSpec = this.theOneSpec.spec[jsonName];
    data[jsonName] = this.getJSON(thisSpec);
  }

  return data;
};

//Описание модальных окон, их свойств и кнопок (все функции выполняются в контексте таска). Открывается оно из таска по this.windows.[имя окна].open().
window.modalWindows = {
  /*    modalExample: {
          onRender(window) {},
          onOpen(window) {},
          onClose(window) {},
          buttons: [
              {
                  caption: "Закрыть",
                  f(window) {
                      window.close();
                  }
              }
          ],
          title: 'Пример модального окна',
          //content: 'Если укажете что-то здесь - оно переопределит то, что указано в HTML!'
      }*/
};


//Кастомная функция для того, что вы обычно пишете в onRender таска. Выполняется в контексте таска.
window.onTaskRender = function(root) {

};

//Кастомная функция. Выполняется по промису когда (document.readyState === 'complete') в контексте таска.
window.onTaskReady = function(root) {

};

//Кастомная функция. Выполняется по промису когда (document.readyState === 'complete') в контексте тасксьюта.
window.onSuiteReady = function(root) {

};

//Обработчик события keydown в таскСьюте. Если возвратить true - дальнейшая обработка нажатия шаблоном прекращается.
window.onSuiteKeydown = function(code, root, event) {
  //Кликаем по ссылкокнопке по пробелу

};

//Кастомная функция для валидации тасков. Выполняется в контексте таска после спекмаппера.
window.validation = function(res, output, solution, errors, root) {
  /*
      В главных ролях:
      res - итоговая солюшка после спекМаппера
      output - ШВшная солюшка
      solution - классическая Толоковская солюшка на входе task.validate()
      errors - ошибки
      root - DOMElement таска
  */

  if (output.data_source && !isLink(output.data_source)) {
    const dataSourceField = root.querySelector('div.elementBody.fieldType_textarea.fieldName_data_source');
    errors = this.addErrorToField(dataSourceField, 'Пожалуйста, введите корректный URL (http://site.ru)', errors);
  }

  if (res.result === "updated" && res.sc_description === "" && res.sc_description_specific.length === 0) {
    const dataSourceField = root.querySelector('div.elementBody.fieldType_textarea.fieldName_sc_description');
    const message = "Пожалуйста, заполните описание класса обслуживания или услуги в отдельных поездах";
    errors = this.addErrorToField(dataSourceField, message, errors);
  }

  return errors;
};

//Опциональная функция, позволяет выполнять любые сложные проверки и преобразования солюшки, которые не предусмотрены стандартной спекой Всевластия
window.solutionChecks = function(solution) {

};

//Методы, которые будут добавлены таску при его инициализации. Если переопределить уже описанные у таска методы - старые сохранятся под именем _метод
window.customTaskMethods = {
};

//Методы, которые будут добавлены таскСьюту при его инициализации. Если переопределить уже описанные у класса методы - старые сохранятся под именем _метод
window.customTaskSuiteMethods = {

};

//Методы, которые будут добавлены классу Assignment при его инициализации. Если переопределить уже описанные у класса методы - старые сохранятся под именем _метод
window.customAssignmentMethods = {
};

//Ваше собственное контекстное меню (включается в настройках выше)

/* -------------------- JavaScript Шаблона Всевластия --------------------
    Тут начинается код загрузки шаблона. Как правило, все методы ШВшной библиотеки вы можете переопределить штатными
    способами, но если уж сильно нужно будет - можно вместо загрузки библиотеки вставить её код под этот комментарий.
*/
if (!window.extend) {
  alert('Кто забыл перенести JS-библиотеку в "шестерёнке" - тот ты! :)');
  throw "grenade!";
}
exports.Assignment = extend(TolokaAssignment, function (options) {
  TolokaAssignment.call(this, options);
}, {
  start: function() {
    loadStuffFromTheOneLibrary(this);
    TolokaAssignment.prototype.start.call(this);
  }
});
