exports.Task = extend(TolokaHandlebarsTask, function (options) {
    TolokaHandlebarsTask.call(this, options);
}, {
    onRender: function () {
        // DOM-элемент задания сформирован (доступен через #getDOMElement())

        var $photos1 = this.getTask().input_values.photo_1;
        var $photos2 = this.getTask().input_values.photo_2;

        console.log($photos1);
        console.log($photos2);

        var window_width = (window.innerWidth > 0) ? window.innerWidth : screen.width;

        var width = 300; // ширина изображения
        var count = 1; // количество изображений
        var padding = 10; // количество изображений

        var carousel_width = Math.floor(window_width / (width + padding * 2 + 40 * 2)) * (width + padding * 2);
        var list_carousel = this.getDOMElement().querySelectorAll('.carousel');
        for (var i = 0; i < list_carousel.length; i++) {
            list_carousel[i].style.width = carousel_width + "px";
        }

        var list_gallery = this.getDOMElement().querySelectorAll('.gallery');
        for (var i = 0; i < list_carousel.length; i++) {
            list_gallery[i].style.width = carousel_width + "px";
        }


        if ($photos1 !== undefined && $photos2 !== undefined && $photos1 !== null && $photos2 !== null) {
            this.getDOMElement().querySelector('#carousel1').style.display = "block";
            this.getDOMElement().querySelector('#carousel2').style.display = "block";


            var ul1 = this.getDOMElement().querySelector('#images1');
            for (var i = 0; i < $photos1.length; i++) {

                var li1 = document.createElement('li');
                ul1.appendChild(li1);
                li1.classList.add("li1");
                var img1 = document.createElement('img');
                img1.src = $photos1[i];
                li1.append(img1);
            }


            var lis1 = this.getDOMElement().querySelectorAll('.li1');
            for (var i = 0; i < lis1.length; i++) {
                lis1[i].style.position = 'relative';
                var span1 = document.createElement('span');
                span1.style.cssText = 'position:absolute;left:0;top:0';
                span1.innerHTML = i + 1;
                lis1[i].appendChild(span1);
            }


            var list1 = this.getDOMElement().querySelector('#images1');
            var listElems1 = list1.querySelectorAll('.li1');

            var position1 = 0; // текущий сдвиг влево

            this.getDOMElement().querySelector('.prev1').onclick = function () {
                position1 = Math.min(position1 + width * count + padding * 2 * count, 0);
                list1.style.marginLeft = position1 + 'px';
            };

            this.getDOMElement().querySelector('.next1').onclick = function () {
                position1 = Math.max(position1 - width * count - padding * 2 * count, (-width - padding * 2) * (listElems1.length - count));
                list1.style.marginLeft = position1 + 'px';
            };


            var ul2 = this.getDOMElement().querySelector('#images2');
            for (var i = 0; i < $photos2.length; i++) {

                var li2 = document.createElement('li');
                ul2.appendChild(li2);
                li2.classList.add("li2");
                var img2 = document.createElement('img');
                img2.src = $photos2[i];
                li2.append(img2);
            }


            var lis2 = this.getDOMElement().querySelectorAll('.li2');
            for (var i = 0; i < lis2.length; i++) {
                lis2[i].style.position = 'relative';
                var span2 = document.createElement('span');
                span2.style.cssText = 'position:absolute;left:0;top:0';
                span2.innerHTML = i + 1;
                lis2[i].appendChild(span2);
            }

            var list2 = this.getDOMElement().querySelector('#images2');
            var listElems2 = list2.querySelectorAll('.li2');

            var position2 = 0; // текущий сдвиг влево

            this.getDOMElement().querySelector('.prev2').onclick = function () {
                position2 = Math.min(position2 + width * count + padding * 2 * count, 0);
                list2.style.marginLeft = position2 + 'px';
            };

            this.getDOMElement().querySelector('.next2').onclick = function () {
                position2 = Math.max(position2 - width * count - padding * 2 * count, (-width - padding * 2) * (listElems2.length - count));
                list2.style.marginLeft = position2 + 'px';
            };


        }

        var id = this.getTask().id;
        var $root = $(this.getDOMElement());

        $root.find('#map').attr("id", "map" + id);

        var DataBasea = {};
        var DataBaseb = {};
        DataBasea.lat = Number(this.getTask().input_values.latitude_1);
        DataBaseb.lat = Number(this.getTask().input_values.latitude_2);
        DataBasea.lon = Number(this.getTask().input_values.longitude_1);
        DataBaseb.lon = Number(this.getTask().input_values.longitude_2);
        var coords1 = [];
        var coords2 = [];
        coords1.push(DataBasea.lat);
        coords1.push(DataBasea.lon);
        coords2.push(DataBaseb.lat);
        coords2.push(DataBaseb.lon);

        //console.log(DataBaseb.lon)
        ymaps.ready(function () {
            //console.log("map")
            $root.find("#map" + id).empty();
            var myCollection = new ymaps.GeoObjectCollection();
            var myMap = new ymaps.Map('map' + id, {
                center: [DataBasea.lat, DataBasea.lon],
                zoom: 10,
                controls: ['zoomControl']
            }, {
                searchControlProvider: 'yandex#search'
            });
            var aPlacemark = new ymaps.Placemark(coords1);
            var bPlacemark = new ymaps.Placemark(coords2);


            myCollection.add(aPlacemark);
            myCollection.add(bPlacemark);

            myMap.geoObjects.add(myCollection);
            myMap.setBounds(myCollection.getBounds());

            myMap.setZoom(16);
            console.log(myMap.getZoom())
        });

        var company_name = this.getDOMElement().querySelector('.company_name');
        var site = this.getDOMElement().querySelector('.site');
        var hotel_category = this.getDOMElement().querySelector('.hotel_category');
        var hotel_phone = this.getDOMElement().querySelector('.hotel_phone');
        var hotel_country = this.getDOMElement().querySelector('.hotel_country');
        var hotel_adress = this.getDOMElement().querySelector('.hotel_adress');

        var $company_name_1 = this.getTask().input_values.company_name_1 || "-";
        var $company_name_2 = this.getTask().input_values.company_name_2 || "-";
        var $url_1 = this.getTask().input_values.url_1 || "-";
        var $url_2 = this.getTask().input_values.url_2 || "-";
        var $category_1 = this.getTask().input_values.category_1 || "-";
        var $category_2 = this.getTask().input_values.category_2 || "-";
        var $phone_1 = this.getTask().input_values.phone_1 || "-";
        var $phone_2 = this.getTask().input_values.phone_2 || "-";
        var $country_1 = this.getTask().input_values.country_1 || "-";
        var $country_2 = this.getTask().input_values.country_2 || "-";
        var $address_1 = this.getTask().input_values.address_1 || "-";
        var $address_2 = this.getTask().input_values.address_2 || "-";

        company_name.style.display = ($company_name_1 === "-" || $company_name_2 === "-") ? 'none' : 'block';
        site.style.display = ($url_1 === "-" || $url_2 === "-") ? 'none' : 'block';
        hotel_category.style.display = ($category_1 === "-" || $category_2 === "-") ? 'none' : 'block';
        hotel_phone.style.display = ($phone_1 === "-" || $phone_2 === "-") ? 'none' : 'block';
        hotel_country.style.display = ($country_1 === "-" || $country_2 === "-") ? 'none' : 'block';
        hotel_adress.style.display = ($address_1 === "-" || $address_2 === "-") ? 'none' : 'block';
    },

    onDestroy: function () {
        // Задание завершено, можно освобождать (если были использованы) глобальные ресурсы
    },

    getTemplateData: function () {
        var data = TolokaHandlebarsTask.prototype.getTemplateData.apply(this, arguments);

        data['short_distance'] = (Number(this.getTask().input_values['distance'])).toFixed(0);

        data['data_company_name_1'] = this.getTask().input_values['company_name_1'] || "-";
        data['data_company_name_2'] = this.getTask().input_values['company_name_2'] || "-";

        data['data_url_1'] = this.getTask().input_values['url_1'] || "-";
        data['data_url_2'] = this.getTask().input_values['url_2'] || "-";

        data['data_category_1'] = this.getTask().input_values['category_1'] || "-";
        data['data_category_2'] = this.getTask().input_values['category_2'] || "-";

        data['data_phone_1'] = this.getTask().input_values['phone_1'] || "-";
        data['data_phone_2'] = this.getTask().input_values['phone_2'] || "-";

        data['data_country_1'] = this.getTask().input_values['country_1'] || "-";
        data['data_country_2'] = this.getTask().input_values['country_2'] || "-";

        data['data_address_1'] = this.getTask().input_values['address_1'] || "-";
        data['data_address_2'] = this.getTask().input_values['address_2'] || "-";
        return data;
    }
});

function extend(ParentClass, constructorFunction, prototypeHash) {
    constructorFunction = constructorFunction || function () {
    };
    prototypeHash = prototypeHash || {};
    if (ParentClass) {
        constructorFunction.prototype = Object.create(ParentClass.prototype);
    }
    for (var i in prototypeHash) {
        constructorFunction.prototype[i] = prototypeHash[i];
    }
    return constructorFunction;
}

