#include "data.h"

#include <travel/hotels/lib/cpp/protobuf/tools.h>

namespace NTravel::NProtobuf {
    template <>
    THotelEntryKey GetIdentifier<THotelEntryKey, NTravelProto::NConfig::THotelLists::THotelEntry>(const NTravelProto::NConfig::THotelLists::THotelEntry& data) {
        return std::make_tuple(data.GetPermalink(), data.GetPartnerId(), data.GetOriginalId());
    }

    template <>
    ui64 GetIdentifier<ui64, NTravelProto::NPartnerParsers::TNormalizeRule>(const NTravelProto::NPartnerParsers::TNormalizeRule& data) {
        return data.GetId();
    }

    template <>
    TString GetIdentifier<TString, NTravelProto::NConfig::TRegionImage>(const NTravelProto::NConfig::TRegionImage& data) {
        return ToString(data.GetGeoId()) + "/" + data.GetUrl();
    }

    template <>
    TString GetIdentifier<TString, NTravelProto::NConfig::TPopularDestination>(const NTravelProto::NConfig::TPopularDestination& data) {
        return ToString(data.GetSrcGeoId()) + "/" + ToString(data.GetDstGeoId());
    }

    template <>
    THotelEntryKey GetIdentifier<THotelEntryKey, NTravelProto::NConfig::TPaymentScheduleHotel>(const NTravelProto::NConfig::TPaymentScheduleHotel& data) {
        return std::make_tuple(0, data.GetPartnerId(), data.GetOriginalId());
    }

    template <>
    ui64 GetIdentifier<ui64, NTravelProto::NConfig::TMirHotel>(const NTravelProto::NConfig::TMirHotel& data) {
        return data.GetPermalink();
    }

    template <>
    THotelImageKey GetIdentifier<THotelImageKey, NTravelProto::NConfig::THotelImage>(const NTravelProto::NConfig::THotelImage& data) {
        return std::make_tuple(data.GetPermalink(), data.GetOrder(), data.GetSize());
    }

    template <>
    TString GetIdentifier<TString, NTravelProto::NConfig::TPromoEvent>(const NTravelProto::NConfig::TPromoEvent& data) {
        return ToString(data.GetEventId());
    }

    template <>
    TString GetIdentifier<TString, NTravelProto::NConfig::TAffiliatePartner>(const NTravelProto::NConfig::TAffiliatePartner& data) {
        return ToString(data.GetAffiliatePartnerName());
    }

    template <>
    TAffiliatePartnerCommissionKey GetIdentifier<TAffiliatePartnerCommissionKey, NTravelProto::NConfig::TAffiliatePartnerCommissionItem>(
        const NTravelProto::NConfig::TAffiliatePartnerCommissionItem& data
    ) {
        return std::make_tuple(data.GetAffiliatePartnerName(), data.GetCategory(), data.GetOrderType());
    }

    template <>
    TAffiliateUserCommissionKey GetIdentifier<TAffiliateUserCommissionKey, NTravelProto::NConfig::TAffiliateUserCommissionItem>(
        const NTravelProto::NConfig::TAffiliateUserCommissionItem& data
    ) {
        return std::make_tuple(data.GetAffiliatePartnerName(), data.GetCategory(), data.GetOrderType(), data.GetUserId());
    }
}



template <>
void Out<THotelEntryKey>(IOutputStream& out, const THotelEntryKey& id) {
    out << std::get<0>(id) << "/" << std::get<1>(id) << "/" << std::get<2>(id);
}


template <>
void Out<THotelImageKey>(IOutputStream& out, const THotelImageKey& id) {
    out << std::get<0>(id) << "/" << std::get<1>(id) << "/" << std::get<2>(id);
}


template <>
void Out<TAffiliatePartnerCommissionKey>(IOutputStream& out, const TAffiliatePartnerCommissionKey& id) {
    out << std::get<0>(id) << "/" << std::get<1>(id) << "/" << std::get<2>(id);
}


template <>
void Out<TAffiliateUserCommissionKey>(IOutputStream& out, const TAffiliateUserCommissionKey& id) {
    out << std::get<0>(id) << "/" << std::get<1>(id) << "/" << std::get<2>(id) << "/" << std::get<3>(id);
}
