#include "worker.h"

#include <travel/hotels/lib/cpp/slack_forwarder_notificator/slack_forwarder_notificator.h>
#include <travel/hotels/lib/cpp/util/arg_replacer.h>

#include <mapreduce/yt/interface/client.h>
#include <library/cpp/getopt/opt.h>


int main(int argc, const char* argv[]) {
    NYT::Initialize(argc, argv);
    TArguments args;
    ui64 commitRevision = 0;
    ui64 sandboxTaskId = 0;
    TString action, ytTokenProd, ytTokenTesting, commitMessage, commitAuthor;
    bool iKnowWhatIAmDoing = false;
    {
        NLastGetopt::TOpts opts;
        opts.AddHelpOption('h');
        opts.AddLongOption('c', "config-dir", "Path to config dir. Autodetected by arcadia root if not specified.")
            .StoreResult(&args.ConfigDir);
        opts.AddLongOption('e', "env", "Environment")
            .StoreResult(&args.Env);
        opts.AddLongOption(  0, "yt-proxy", "Yt Proxy")
            .EmplaceTo(&args.YtProxies);
        opts.AddLongOption('t', "yt-token", "Yt Token")
            .StoreResult(&args.YtToken);
        opts.AddLongOption(  0, "yt-token-path", "Yt Token Path")
            .StoreResult(&args.YtTokenPath);
        opts.AddLongOption('p', "yt-path", "Yt Config Path")
            .StoreResult(&args.YtPath);
        opts.AddLongOption(  0, "for-tests-only-enable-all-operators", "Only for autotests! Enable all operators")
            .NoArgument()
            .SetFlag(&args.EnableAllOperators);
        opts.AddLongOption(  0, "skip-all-operators-defined-check", "Probably you need it if you delete an operator")
            .NoArgument()
            .SetFlag(&args.SkipAllOperatorsDefinedCheck);
        opts.AddLongOption(  0, "skip-all-partners-defined-check", "Probably you need it if you delete a partner")
            .NoArgument()
            .SetFlag(&args.SkipAllPartnersDefinedCheck);
        opts.AddLongOption(  0, "i-know-what-i-am-doing", "Very secret option")
            .NoArgument()
            .SetFlag(&iKnowWhatIAmDoing);
        // only for push-internal
        opts.AddLongOption(  0, "yt-token-prod", "Yt Token for prod (for internal use only)")
            .StoreResult(&ytTokenProd);
        opts.AddLongOption(  0, "yt-token-testing", "Yt Token for testing (for internal use only)")
            .StoreResult(&ytTokenTesting);
        opts.AddLongOption(  0, "commit-revision", "for internal use only")
            .StoreResult(&commitRevision);
        opts.AddLongOption(  0, "commit-author", "for internal use only")
            .StoreResult(&commitAuthor);
        opts.AddLongOption(  0, "commit-message", "for internal use only")
            .StoreResult(&commitMessage);
        opts.AddLongOption(  0, "sandbox-task-id", "for internal use only")
            .StoreResult(&sandboxTaskId);
        opts.SetFreeArgsNum(1);
        opts.SetFreeArgTitle(0, "action", "push-internal/push/diff/forcepush");
        NTravel::TArgReplacer replacer(argc, argv);
        NLastGetopt::TOptsParseResult res(&opts, replacer.GetArgC(), replacer.GetArgV());
        action = res.GetFreeArgs().at(0);
    }
    if (action == "push-internal") {
        if (args.Env != "do-not-call-me-manually") {
            throw yexception() << "Do not call push-internal manually";
        }
        NTravel::TSlackForwarderNotificator notificator("http://travel-slack-forwarder.yandex.net:9098", "CfgTool - Configs", sandboxTaskId, commitRevision);
        notificator.RegisterBuildNoThrow(commitMessage, commitAuthor);
        if (ytTokenTesting) {
            args.Env = "testing";
            args.YtToken = ytTokenTesting;
            TWorker(args).PushInternal(notificator, "Testing", commitRevision);
        }
        if (ytTokenProd) {
            args.Env = "prod";
            args.YtToken = ytTokenProd;
            TWorker(args).PushInternal(notificator, "Stable", commitRevision);
        }
    } else if (action == "push" || action == "forcepush") {
        if (!iKnowWhatIAmDoing) {
            throw yexception() << "Do not call push anymore, just commit your changes";
        }
        TWorker(args).Push(action == "forcepush");
    } else if (action == "diff") {
        TWorker(args).Diff();
    } else if (action == "validate") {
        if (args.Env) {
            TWorker(args).Validate();
        } else {
            args.Env = "testing";
            TWorker(args).Validate();
            args.Env = "prod";
            TWorker(args).Validate();
        }
    } else {
        throw yexception() << "Unknown action " << action;
    }
    return 0;
}
