#pragma once

#include "yt_cache.h"

#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/generic/hash.h>
#include <util/generic/map.h>
#include <util/generic/maybe.h>
#include <util/folder/path.h>

namespace NTravel {
    class TSlackForwarderNotificator;
}

struct TArguments {
    TString ConfigDir;
    TString Env;
    TString YtTokenPath;
    TString YtToken;
    TString YtPath;
    TVector<TString> YtProxies;
    bool EnableAllOperators = false;
    bool SkipAllOperatorsDefinedCheck = false;
    bool SkipAllPartnersDefinedCheck = false;

    const TArguments& SetupDefaultsAndCheck();
};

class TWorker {
public:
    TWorker(TArguments args);
    ~TWorker() = default;

    void Push(bool force);
    void Diff();
    void Validate();
    void PushInternal(NTravel::TSlackForwarderNotificator& notificator, const TString& notifyEnv, ui64 commitRevision);
private:
    enum EAction {
        EA_Validate,
        EA_Diff,
        EA_Push,
    };

    const TArguments Args;
    const TFsPath ConfigPath;

    TMaybe<ui64> CommitRevision;

    EAction Action = EA_Validate;
    bool ForceWrite = false;

    template <class TConfig>
    TConfig ReadProtoConfig(const TString& name);
    template <class TId, class TProto>

    void WriteConfig(const TMap<TId, TProto>& records, TYtCachePtr cache, const TString& ytTable);
    template <class TId, class TProto>
    bool ReadConfig(TYtCachePtr cache, const TString& ytTable,  TMap<TId, TProto>* records);

    template <class TId, class TProto>
    void ProcessConfig(const TMap<TId, TProto>& localRecords, TYtCachePtr cache, const TString& tableName);

    template <class TId, class TProto>
    bool CompareConfig(const TMap<TId, TProto>& localRecords, TYtCachePtr cache, const TString& ytTable);

    template <class TId, class TProto>
    void SetExplicitDefaultValues(TMap<TId, TProto>* data);

    void DoWork();
};
