#pragma once

#include <travel/hotels/lib/cpp/util/flag.h>

#include <mapreduce/yt/interface/client.h>

#include <util/generic/hash.h>
#include <util/generic/vector.h>
#include <util/generic/ptr.h>
#include <util/system/mutex.h>
#include <util/thread/pool.h>

struct TCachedTableData : public TThrRefBase {
    TVector<NYT::TNode> Rows;
};

using TCachedTableDataPtr = TIntrusivePtr<TCachedTableData>;

class TYtCache : public TThrRefBase {
public:
    TYtCache(const TString& proxy, const TString& tokenPath, const TString& token, const TString& path);
    ~TYtCache();

    const TString& Proxy() {
        return Proxy_;
    }
    const TString& Path() {
        return Path_;
    }

    void Start();
    void Stop();

    ui64 GetRevision();
    void SetRevision(ui64 revision);

    TCachedTableDataPtr Read(const TString& tablePath) const; // nullptr if not exists
    void Write(const TString& tablePath, const NYT::TTableSchema& schema, TCachedTableDataPtr data);
    bool Commit();

private:
    struct TReadTableInfo : public TThrRefBase {
        TAtomicFlag ReadFinished;
        TString     ReadError;
        TCachedTableDataPtr Data;
    };
    using TReadTableInfoPtr = TIntrusivePtr<TReadTableInfo>;

    struct TWriteTableInfo : public TThrRefBase {
        TString     WriteError;
    };
    using TWriteTableInfoPtr = TIntrusivePtr<TWriteTableInfo>;

    const TString Proxy_;
    const TString Path_;
    NYT::IClientPtr Client_;
    NYT::ITransactionPtr Tx_;

    TThreadPool Threads_;

    TMutex Lock_;
    TString CommonReadError_;
    THashMap<TString, TReadTableInfoPtr> ReadTables_;

    size_t ActiveWriters_;
    THashMap<TString, TWriteTableInfoPtr> WriteTables_;
};

using TYtCachePtr = TIntrusivePtr<TYtCache>;
