package main

import (
	"a.yandex-team.ru/library/go/yandex/yav/httpyav"
	"a.yandex-team.ru/travel/hotels/lib/go/yavconf"
	"context"
	"fmt"
	"github.com/heetch/confita"
	"github.com/heetch/confita/backend/env"
	"github.com/heetch/confita/backend/file"
	"github.com/heetch/confita/backend/flags"
)

const (
	robotTravelProdSecret      = "sec-01d8t7zednvzpayps7k0pf12vb"
	robotTravelModeratorSecret = "sec-01ejdxh8r3qfe7qdc55bxk2h3d"
	hotelPartnersSecret        = "sec-01ddqrmtm6vyehw2n4wz3qan16"
)

type nightConfig struct {
	Start string `config:"bot-night-start,required"`
	End   string `config:"bot-night-end,required"`
}

type botConfig struct {
	AllowedLogins     []string `config:"bot-allowedlogins,required"`
	Token             string   `config:"telegram-bot-token,required"`
	Night             *nightConfig
	RatePlanListLimit int `config:"bot-rateplanlistlimit,required"`
}

type metaConfig struct {
	VaultToken string `config:"vault-token,required"`
	Env        string `config:"env"`
	CfgPath    string `config:"cfg-path"`
}

type stConfig struct {
	Token                 string   `config:"st-token,backend=yav"`
	OrgID                 string   `config:"st-orgid,required"`
	TicketIntervalMinutes int      `config:"st-ticketintervalminutes"`
	TLQueue               string   `config:"st-tlqueue,required"`
	BNQueue               string   `config:"st-bnqueue,required"`
	TLTags                []string `config:"st-tltags"`
	BNTags                []string `config:"st-bntags"`
}

type ytConfig struct {
	Token             string   `config:"yt-oauth-key,required,backend=yav"`
	MainCluster       string   `config:"yt-maincluster,required"`
	OfferClusters     []string `config:"yt-offerclusters,required"`
	WhiteListClusters []string `config:"yt-whitelistclusters,required"`
	OfferBusPath      string   `config:"yt-offerbuspath,required"`
	Path              string   `config:"yt-path,required"`
}

type tlConfig struct {
	APIKey  string `config:"travelline-api-key,required,backend=yav"`
	BaseURL string `config:"partners-travelline-baseurl,required"`
}

type bnConfig struct {
	Username   string `config:"bnovo-api-username,backend=yav"`
	Password   string `config:"bnovo-new-password,backend=yav"`
	PublicURL  string `config:"parners-bnovo-publicurl,required"`
	PrivateURL string `config:"partners-bnovo-privateurl,required"`
}

type partnersConfig struct {
	BNovo      bnConfig
	Travelline tlConfig
}

type config struct {
	Bot                   botConfig
	Partners              partnersConfig
	ST                    stConfig
	YT                    ytConfig
	LandingLabel          string `config:"landinglabel,required"`
	LandingPrefix         string `config:"landingprefix,required"`
	LoadWhiteLists        bool   `config:"loadwhitelists"`
	QueueSize             int    `config:"queuesize,required"`
	RepeatIntervalMinutes int    `config:"repeatintervalminutes,required"`
	SaveIntervalMinutes   int    `config:"saveintervalminutes,required"`
	TMPDir                string `config:"tmpdir,required"`
	LogDir                string `config:"logdir"`
	QueueAlertLimit       int    `config:"queuealertlimit,required"`
}

func LoadConfig(ctx context.Context) (*config, error) {
	envBackend := env.NewBackend()
	flagsBackend := flags.NewBackend()
	metaLoader := confita.NewLoader(envBackend, flagsBackend)
	var mc metaConfig
	err := metaLoader.Load(context.Background(), &mc)
	if err != nil {
		return nil, err
	}
	yavClient, err := httpyav.NewClient(httpyav.WithOAuthToken(mc.VaultToken))
	if err != nil {
		return nil, err
	}

	yavBackend := yavconf.NewBackend(yavClient, robotTravelProdSecret, robotTravelModeratorSecret, hotelPartnersSecret)
	var filepath string
	if mc.CfgPath != "" {
		filepath = mc.CfgPath
	} else if mc.Env != "" {
		filepath = fmt.Sprintf("application-%s.yaml", mc.Env)
	}
	var mainLoader *confita.Loader
	if filepath != "" {
		fileBackend := file.NewBackend(filepath)
		mainLoader = confita.NewLoader(envBackend, flags.NewBackend(), fileBackend, yavBackend)
	} else {
		mainLoader = confita.NewLoader(envBackend, yavBackend)
	}

	var cfg config
	err = mainLoader.Load(ctx, &cfg)
	if err != nil {
		return nil, err
	} else {
		return &cfg, nil
	}
}
