package moderator

type action int

const (
	put    action = iota
	get    action = iota
	list   action = iota
	remove action = iota
	stats  action = iota
)

type command struct {
	action   action
	item     *RatePlanItem
	id       HotelID
	plan     string
	response chan cmdResponse
}

type cmdResponse struct {
	items []*RatePlanItem
	stats *Statistics
}

func (c *command) respond(r cmdResponse) {
	c.response <- r
}

func (c *command) getResponse() cmdResponse {
	return <-c.response
}

func putCMD(item *RatePlanItem) command {
	return command{
		action:   put,
		item:     item,
		response: make(chan cmdResponse),
	}
}

func getCMD(id HotelID, plan string) command {
	return command{
		action:   get,
		id:       id,
		plan:     plan,
		response: make(chan cmdResponse),
	}
}

func listCMD(id HotelID) command {
	return command{
		action:   list,
		id:       id,
		response: make(chan cmdResponse),
	}
}

func removeCMD(id HotelID, plan string) command {
	return command{
		action:   remove,
		id:       id,
		plan:     plan,
		response: make(chan cmdResponse),
	}
}

func statsCMD() command {
	return command{
		action:   stats,
		response: make(chan cmdResponse),
	}
}
