package partners

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"net/http"
	"net/url"
)

type RatePlan struct {
	Code        string `json:"code"`
	Name        string `json:"name"`
	Description string `json:"description"`
}

type Hotel struct {
	RatePlans []RatePlan `json:"rate_plans"`
	Code      string     `json:"code"`
	Name      string     `json:"name"`
}

type HotelInfoResponse struct {
	Hotel Hotel `json:"hotel"`
}

type TravellineClient struct {
	APIKey  string
	BaseURL string
}

func (c *TravellineClient) GetTLRatePlanAndHotel(hotelID string, ratePlanID string) (*RatePlan, *Hotel, error) {
	request, err := http.NewRequest("GET", fmt.Sprintf("%s/booking/hotel_info", c.BaseURL), nil)
	if err != nil {
		return nil, nil, err
	}
	args := url.Values{}
	args.Add("hotel.code", hotelID)
	args.Add("language", "ru-ru")
	request.URL.RawQuery = args.Encode()
	header := http.Header{}
	header.Add("X-ApiKey", c.APIKey)
	request.Header = header
	resp, err := http.DefaultClient.Do(request)
	if err != nil {
		return nil, nil, err
	}
	if resp.StatusCode != 200 {
		return nil, nil, fmt.Errorf("unexpected status code %d when calling TL API", resp.StatusCode)
	}
	result, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, nil, err
	}
	var response HotelInfoResponse
	err = json.Unmarshal(result, &response)
	if err != nil {
		return nil, nil, err
	}
	for _, rp := range response.Hotel.RatePlans {
		if rp.Code == ratePlanID {
			return &rp, &response.Hotel, nil
		}
	}
	return nil, nil, nil
}
