#! /usr/bin/env python

from datetime import datetime, timedelta
from typing import NamedTuple, Optional, Tuple, Union, List
import hashlib

from travel.library.python.time_interval import TimeInterval


class YtTriggerConfig(NamedTuple):
    path: str
    min_age: Optional[timedelta]
    max_age: Optional[timedelta]
    creation_date_from: Optional[datetime]
    name_from: Optional[str]
    table_name_exclude_pattern: Optional[str]
    ignore_modifications: bool


class PlanFile(NamedTuple):
    name: str
    data: str


class RawPlan(NamedTuple):
    files: List[PlanFile]
    commit_revision: int


class PlanItem(NamedTuple):
    at: Optional[Union[str, datetime]]
    yt_trigger: Optional[List[YtTriggerConfig]]
    plan_id: str
    resource: str
    do_extract: bool
    requires_dns64: bool
    command: str
    args: str
    semaphore_name: Optional[str]
    concurrency: Optional[int]
    kill_timeout: TimeInterval
    task_type: str
    tags: Tuple[str, ...]
    output_resources_file: Optional[str]
    notify_email: str
    notify_on_success: bool
    container_resource: int

    def replace(self, **kwargs):
        return self._replace(**kwargs)

    def calc_hash(self):
        parts = list()
        for field_name in sorted(self._fields):
            field_value = getattr(self, field_name)
            parts.append(f'{field_name}: {field_value}')
        m = hashlib.sha256()
        m.update(','.join(parts).encode('utf-8'))
        return m.hexdigest()


class YtNodeInfo(NamedTuple):
    plan_id: str
    node: str
    version: int
