# -*- coding: utf-8 -*-

from typing import Dict, Tuple
import dataclasses


@dataclasses.dataclass(frozen=True)
class Environment:
    notify_on_success: bool
    notify_email: str = ''
    released_at: str = ''
    sb_token_secret: str = ''
    tags: Tuple[str, ...] = ()
    yt_root: str = ''
    yt_token_secret: str = ''
    sb_owner: str = ''

    def replace(self, **kwargs):
        return dataclasses.replace(self, **kwargs)


TESTING_ENVIRONMENT = Environment(
    notify_on_success=False,
    notify_email='travel-sandbox-testing@yandex-team.ru',
    released_at='testing',
    sb_token_secret='sec-01e31wpv6r4r8y7sa2e8k3azj1',
    tags=('TRAVEL_SANDBOX_PLANNER', 'ENV:TESTING',),
    yt_root='//home/travel/testing/general/sandbox',
    yt_token_secret='sec-01d1x4rf3p808k64h608xh89qq.key-value',
    sb_owner='TRAVEL',
)

PROD_ENVIRONMENT = Environment(
    notify_on_success=False,
    notify_email='travel-sandbox-prod@yandex-team.ru',
    released_at='stable',
    sb_token_secret='sec-01d8t7zednvzpayps7k0pf12vb.key-sandbox-oauth-key',
    tags=('TRAVEL_SANDBOX_PLANNER', 'ENV:PROD',),
    yt_root='//home/travel/prod/general/sandbox',
    yt_token_secret='sec-01d8t7zednvzpayps7k0pf12vb.key-yt-oauth-key',
    sb_owner='TRAVEL',
)


ENVIRONMENTS: Dict[str, Environment] = {
    'testing': TESTING_ENVIRONMENT,
    'prod': PROD_ENVIRONMENT,
}
